package gov.va.med.esr.common.batchprocess;

import java.util.Date;
import java.util.HashMap;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.persistent.report.ReportDAO;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.service.CampLejeuneService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.trigger.Log4jTriggerEvent;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.StringUtils;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Mar 10, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class TestCampLejeuneImportProcess extends
	RuleAbstractTestCase //AbstractScheduledProcessTest
{

	private CampLejeuneImportProcess batchProcess;
	/**
	 * @return Returns the batchProcess.
	 */
	public CampLejeuneImportProcess getBatchProcess() {
		return batchProcess;
	}

	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(CampLejeuneImportProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}    

	public void testOriginalSampleFile() throws Exception
	{
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) this.applicationContext.getBean("common.batchprocess.CampLejeuneImportProcess");
		process.invoke(null);
	}
	
	public void testWriteSuccessReport () throws Exception
	{
		String succData = "ICN|FirstName|LastName|SSN|DOB|Gender|OldPriorityGroup|NewPriorityGroup\n" +
						"1008692273V906290|JohnD|AcrocanthosaurusD|454321321|19771013|M||\n" +
						"1008519846V083682|WYATT|ROMIE|342300622|19440404|M||\n" +
						"1008593523V062131|AHADH|HADHA|432724753|19821011|M|Group 5|Group 5";
		
		ReportDAO reportDAO = (ReportDAO) this.applicationContext.getBean("reportDAO");
		
		CompletedReport report = new CompletedReport();
		report.setCompletedDate( new Date());
		report.setUser( new ESRUserPrincipalImpl (SecurityContextHelper.getSecurityContext().getUserPrincipal().getName()));
		try {
			StandardReport stdRp = this.getLookupService().getStandardReportByCode(StandardReport.CODE_VOA_01.getCode());
			stdRp.getType().setActive(true);
			report.setStandardReport(stdRp);
			report.setFileType( getLookupService().getReportExportedTypeByCode(ReportExportedType.CSV.getCode()) );
		} catch (Exception ex) {
			logger.error("Failed to lookup CLEAR Import Report Type:" + ex); 
		}
		
		report.setReportFileContent(succData.getBytes());
		
	    try {
			reportDAO.saveCompletedReport( report );
		} catch( DAOException e ) {
				throw new IllegalStateException( "Failed to persist CLEAR Import Detail Successful Report", e );
		}
		
		this.setComplete();
	}
	
	public void testParsingBlankCLE() {
		String input = "1470|1948|HADHA|AHADH|PENDING|432724753||19821011|M|123 OLD WAYH|MARTINSBURG|WV|25401|(123)123-1234|||2013-01-15||USMC,Other,|||||DNS   NguyeH|2015-01-13 08:43:20.290|Testing comments^^^Test comments. Comments and 1-to-N comments.|2015-01-13 09:18:16.193";
		
	}
	public void testProcesCLEARRules() throws Exception
	{
		
		//run the batch job
		CampLejeuneService srv = (CampLejeuneService) this.applicationContext.getBean("campLejeuneService");
		
		//vpid=0000001008594325V000459000000, person_id=377269165
		CampLejeuneImportData data = getData("SANDY", "KIM", "457321238", "04/05/1945", "F",
				"Yes", "2015-02-01", "NPRC,DPRIS,Other,", "Testing comments^^^Test comments. Comments and 1-to-N comments.");
		
			Person clearPerson = srv.findPersonWithCLEARData(data);
		
			String[] reasonTxt = srv.processCLEARData(clearPerson);
			
			if (reasonTxt != null)
				logger.error("CLEAR extract import with exception reason: " + reasonTxt);
		
	}
/*

YeClearID|PersonID|Last_Name|First_Name|Middle_Name|SSN|Service_Number|DOB|Gender|Address|ASCity|State|ZIPCode|Primary_Phone|Secondary_Phone|Email|Registered_Date|Residency_Verified|Residency_Proof|Vet_Branch_Of_Service|Vet_Component|Reason_For_Denial|Reason_For_Denial_Comments|Last_Updated_By|Last_Updated_Date|Residency_Comments|Extract_date
12837|13960|AcrocanthosaurusD|JohnD||454321321||19771013|M|** 150 MUIR ROAD|MARTINEZ|CA|94553|(205)339-7603|||2014-08-13|Yes|NPRC,DPRIS,Other,|||||DNS   NguyeH|2015-01-13 08:40:43.023|TEsting Comments^^^Comments second time.|2015-01-30 09:18:16.193
1288|1767|HENDERSON|NORMA||222222222||19300813|M|800 POLYPLACE|B KLYN|NY|11204|(814)438-3112|||2012-12-18|Yes|DoD,NPRC,CDC,Other,|||||DNS   NguyeH|2015-01-13 08:44:20.933|Comments on Other^^^Comments on Verified residency Other checked.|2015-01-13 09:18:16.193
1469|1948|GENDY|MINA||000000000||1900|M|123 OLD WAYH|MARTINSBURG|WV|25401|(123)123-1234|||2013-01-15|Yes|USMC,Other,|||||DNS   NguyeH|2015-01-13 08:43:20.290|Testing comments^^^Test comments. Comments and 1-to-N comments.|2015-01-13 09:18:16.193
12834|13957|ZZZWOODS|RODNEY||333333333||19480102||||||(702)746-8690|||2014-06-16|||||||DNS   Alert|2015-01-13 08:41:42.483||2015-01-13 09:18:16.193
12836|13960|ZZDOCKEY|BERNARD|I|111111111||1920|M|** 150 MUIR ROAD|MARTINEZ|CA|94553|(205)339-7603|||2014-08-13|Yes|NPRC,DPRIS,Other,|||||DNS   NguyeH|2015-01-13 08:40:43.023|TEsting Comments^^^Comments second time.|2015-01-13 09:18:16.193	

*/
	private CampLejeuneImportData getData(String firstName, String lastName, String ssn, String dob, String gender, 
			String cleIndicator, String clRegistrationDate, String verifiedMethod, String comments ) {

		CampLejeuneImportData data = new CampLejeuneImportData();
		data.setFirstName(firstName);
		data.setLastName(lastName);
		data.setSsn(ssn);
		data.setDob(dob);
		data.setGender(gender);
		
		data.setCleIndicator(cleIndicator);
		data.setClRegistrationDate(clRegistrationDate);
		data.setVerifiedMethod(verifiedMethod);
		data.setComments(comments);
		return data;
	}

}
