/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess;

import org.quartz.JobDetail;
import org.quartz.Scheduler;

import gov.va.med.fw.scheduling.SchedulingService;

import gov.va.med.esr.common.util.AbstractCommonTestCase;

/**
 * Initial javadoc for class TestBatchProcessScheduling.
 * TODO - Add content here
 * 
 * Created Feb 13, 2006 11:17:41 AM
 * @author DNS   BOHMEG
 */
public class TestBatchProcessScheduling extends AbstractCommonTestCase {
	private SchedulingService schedulingService;
	
	public void testGetCurrentTriggers() throws Exception {
		String[] triggerNames = schedulingService.getScheduler().getTriggerNames(Scheduler.DEFAULT_GROUP);
		for(int i=0; i<triggerNames.length; i++) {
			System.out.println("Scheduler has trigger: " + triggerNames[i]);
		}
	}
	
	public void testSameTriggerMultipleTimes() throws Exception {
		JobDetail jobDetail = (JobDetail) applicationContext.getBean("mock.jobDetail");
		for(int i=0; i<10; i++) {
			// 0.017 * 60 is one minute
			schedulingService.schedule(jobDetail, null, 0.017, "testTrigger" + i, null);
		}
		// only uncomment if these are to be persisted in database (if using persistent JobStore)
		//setComplete();
		System.out.println("registered all triggers");
	}

	/**
	 * @return Returns the schedulingService.
	 */
	public SchedulingService getSchedulingService() {
		return schedulingService;
	}

	/**
	 * @param schedulingService The schedulingService to set.
	 */
	public void setSchedulingService(SchedulingService schedulingService) {
		this.schedulingService = schedulingService;
	}
}
