/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;

/**
 * @author DNS   MANSOG
 *
 */
public class ExpireMeansTestBatchProcessTest extends AbstractScheduledProcessTest {
	private ExpireMeansTestProcess batchProcess;
	private EligibilityEnrollmentService	eligibilityEnrollmentService	=null;
	/**
	 * @return Returns the eligibilityEnrollmentService.
	 */
	public EligibilityEnrollmentService getEligibilityEnrollmentService() {
		return eligibilityEnrollmentService;
	}

	/**
	 * @param eligibilityEnrollmentService
	 *            The eligibilityEnrollmentService to set.
	 */
	public void setEligibilityEnrollmentService(
			EligibilityEnrollmentService eligibilityEnrollmentService) {
		this.eligibilityEnrollmentService = eligibilityEnrollmentService;
	}

	/**
	 * @return Returns the batchProcess.
	 */
	public ExpireMeansTestProcess getBatchProcess() {
		return batchProcess;
	}

	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(ExpireMeansTestProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}
	public void processData() {
		DataQueryProcessExecutionContext context = new DataQueryProcessExecutionContext();
	    // context.setExecutionContext("JUnit");
		   
		BigDecimal personId = new BigDecimal(373961091);//(BigDecimal) row[0];
		
			try {
				if (eligibilityEnrollmentService.processExpiredMeansTestForBatchProcess(new PersonIdEntityKeyImpl(personId))) {
				  //  context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }else {
                    //Record is not processed as the Veteran is not subject to Means Test
                    ((ExpireMeansTestProcessStatistics) context.getProcessStatistics()).incrementNumberOfNotSubjectToMeansTestRecords();
                }
			} catch (Exception ex) {
				//context.getProcessStatistics().incrementNumberOfErrorRecords();
				String errMsg = "Error while executing Expire MeansTest batch process for person "
								+ personId;
			//	context.getExceptionData().add(errMsg+ " Reason: "+ ex.getMessage());
				if(logger.isWarnEnabled())
					logger.warn(errMsg + " Reason: ", ex);
			}
            
			
	}

}
