package gov.va.med.esr.common.batchprocess;

import java.util.Iterator;
import java.util.List;

import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.batchprocess.model.JobResult;

import gov.va.med.esr.common.batchprocess.AppointmentConversionProcess;
import gov.va.med.esr.common.batchprocess.AppointmentConversionStatistics;

public class AppointmentConversionProcessTest extends 	AbstractScheduledProcessTest {


	private AppointmentConversionProcess batchProcess;
	
	private static final String JOB_NAME = "Job-AppointmentConversionProcess";
	private static final String JOB_GROUP = "DEFAULT";

	/**
	 * @return Returns the batchProcess.
	 */
	public AppointmentConversionProcess getBatchProcess() {
		return batchProcess;
	}
	public void testProcess() throws Exception {
		// no op
	}
	public  void testJobResult() throws Exception {
		List results = this.getBatchProcess().getBatchProcessService().getFinishedJobResults(JOB_NAME, JOB_GROUP);
		assertNotNull(results);		
		int totalCancel = 0;
		int totalRejects = 0;
		for (Iterator iter = results.iterator(); iter.hasNext();) {
			JobResult result = (JobResult) iter.next();
			String str = result.getStatistics();
			
			AppointmentConversionStatistics stats = new AppointmentConversionStatistics();
			stats.importFromCSV(str);
			System.out.println("canceled ="+stats.getNumberWithCancelledDeclinedStatus()+" rejected="+stats.getNumberWithRejectedEnrollmentStatus());
			totalCancel += stats.getNumberWithCancelledDeclinedStatus();
			totalRejects += stats.getNumberWithRejectedEnrollmentStatus();
		}   		
		System.out.println("total canceled ="+totalCancel +"  total rejects="+totalRejects);
	}

	protected Object getExecutionArguments() {
		
		return "-size=1";
	}	
	
	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(AppointmentConversionProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	
	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}	
}
