/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.util.AbstractServiceTestCase;
import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;

/**
 * Initial javadoc for class AbstractScheduledProcessTest.
 * TODO - Add content here
 * 
 * Created Feb 2, 2006 5:41:27 PM
 * @author DNS   BOHMEG
 */
public abstract class AbstractScheduledProcessTest extends
		AbstractServiceTestCase {
	public void testProcess() throws Exception {
		getScheduledProcess().invoke(createTestContext(this.getScheduledProcess().getAuditInfo(null), null));
	}

	public void testProcessWithArguments() throws Exception {
		Object args = getExecutionArguments();
		if(args != null) {
			getScheduledProcess().invoke(createTestContext(this.getScheduledProcess().getAuditInfo(null), args));
		}
		// else do nothing since that is covered by testProcess() test
	}
	
	public static ScheduledProcessInvocationContext createTestContext(String jobName, Object args) {
		ScheduledProcessInvocationContext context = new ScheduledProcessInvocationContext();
		context.setInvocationArguments(args);
		context.setExecutionContext("JUnit");
		context.setJobName(jobName);		
		
		return context;
	}
	
	protected Object getExecutionArguments() {
		// default is nothing - override in subclass if needed
		return null;
	}
	
	protected abstract ScheduledProcess getScheduledProcess();
}
