// Created May 24, 2005 11:32:35 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.ps.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.LogFactory;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.person.Person;

/**
 * Initial javadoc for class PersonVPID.
 * TODO - Add content here
 *
 * @author DNS   BOHMEG
 */
public class PersonVPID extends AbstractKeyedEntity {
    private static final long serialVersionUID = -2055825567936778359L;

    public static final BigDecimal HARDCODED_PERSONID_ID1 = new BigDecimal("401");
	public static final BigDecimal HARDCODED_PSIM_VPID_ID1 = new BigDecimal("401");
	public static final String HARDCODED_PSIM_VPID_VALUE1 = "0000001008596039V736719000000";
    public static final BigDecimal HARDCODED_PERSONID_ID2 = new BigDecimal("407");
	public static final BigDecimal HARDCODED_PSIM_VPID_ID2 = new BigDecimal("407");
	public static final String HARDCODED_PSIM_VPID_VALUE2 = "0000002000000404V355568000000";
    public static final BigDecimal HARDCODED_PERSONID_ID3 = new BigDecimal("406");
	public static final BigDecimal HARDCODED_PSIM_VPID_ID3 = new BigDecimal("406");
	public static final String HARDCODED_PSIM_VPID_VALUE3 = "0000002000000403V127036000000";
    public static final BigDecimal HARDCODED_PERSONID_ID4 = new BigDecimal("405");
	public static final BigDecimal HARDCODED_PSIM_VPID_ID4 = new BigDecimal("405");
	public static final String HARDCODED_PSIM_VPID_VALUE4 = "0000002000000402V091284000000";
    public static final BigDecimal HARDCODED_PERSONID_ID5 = new BigDecimal("399");
	public static final BigDecimal HARDCODED_PSIM_VPID_ID5 = new BigDecimal("399");
	public static final String HARDCODED_PSIM_VPID_VALUE5 = "0000002000000396V990989000000";

	public static final String DEFAULT_TESTING_VPID = HARDCODED_PSIM_VPID_VALUE1;

    public static Set VALID_PERSON_IDS;
	public static Set VALID_VPIDS;
	public static Set VALID_VPID_IDS;
	private String vpidValue;

	// FIXME: emergency fixes
	private String idStateInd ="P"; //default pending
	private Date idUpdatEventDate = new Date(); //default now
	private String idTxnType = "M"; //default


	static {
		VALID_VPIDS = new HashSet();
		VALID_VPIDS.add(HARDCODED_PSIM_VPID_VALUE1);
		VALID_VPIDS.add(HARDCODED_PSIM_VPID_VALUE2);
		VALID_VPIDS.add(HARDCODED_PSIM_VPID_VALUE3);
		VALID_VPIDS.add(HARDCODED_PSIM_VPID_VALUE4);
		VALID_VPIDS.add(HARDCODED_PSIM_VPID_VALUE5);

		VALID_VPID_IDS = new HashSet();
		VALID_VPID_IDS.add(HARDCODED_PSIM_VPID_ID1);
		VALID_VPID_IDS.add(HARDCODED_PSIM_VPID_ID2);
		VALID_VPID_IDS.add(HARDCODED_PSIM_VPID_ID3);
		VALID_VPID_IDS.add(HARDCODED_PSIM_VPID_ID4);
		VALID_VPID_IDS.add(HARDCODED_PSIM_VPID_ID5);

        VALID_PERSON_IDS = new HashSet();
        VALID_PERSON_IDS.add(HARDCODED_PERSONID_ID1);
        VALID_PERSON_IDS.add(HARDCODED_PERSONID_ID2);
        VALID_PERSON_IDS.add(HARDCODED_PERSONID_ID3);
        VALID_PERSON_IDS.add(HARDCODED_PERSONID_ID4);
        VALID_PERSON_IDS.add(HARDCODED_PERSONID_ID5);
	}

	public PersonVPID() {
	}

	public PersonVPID(String value) {
		vpidValue = value;
	}


	public void attach(Person person) {
		initializeVPID(person, this);
	}

	public static void initializeVPID(Person person, PersonVPID vpid) {
		try {
			if(vpid.getVpidValue() == null) {
				LogFactory.getLog(vpid.getClass()).error("[Testing mode] PersonVPID has a null vpidValue...using this VPID as default: " + DEFAULT_TESTING_VPID);
				vpid.setVpidValue(DEFAULT_TESTING_VPID);
			}

			Class[] paramTypes = new Class[] { PersonVPID.class };
			Method method = person.getClass().getDeclaredMethod("setVPID", paramTypes);
			Object[] params = new Object[] { vpid };
			method.setAccessible(true);
			method.invoke(person, params);  // satisfy FK

			paramTypes = new Class[] { String.class };
			method = person.getClass().getDeclaredMethod("setVPIDValue", paramTypes);
			params = new Object[] { vpid.getVpidValue() };
			method.setAccessible(true);
			method.invoke(person, params);

			// provide unique default to get around constraint on PSIM.PS_PERSONVPID table
			String junkVPID = "ESR-" + System.currentTimeMillis() + "-";
			while(junkVPID.length() < 16)
				junkVPID = junkVPID + RandomStringUtils.randomAlphanumeric(1);
			vpid.setVpidValue(junkVPID);
		}
		catch (Exception e) {
			throw new IllegalStateException("Exception in setting private VPID data");
		}
	}

	public static void initializeVPID(Person person, String vpidValue) {
		initializeVPID(person, new PersonVPID(vpidValue));
	}

	/**
	 * @param vpidValue The vpidValue to set.
	 */
	public void setVpidValue(String vpidValue) {
		this.vpidValue = vpidValue;
	}

	public String getVpidValue() {
		return vpidValue;
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("vpidValue", vpidValue);
	}

	public String getIdStateInd() {
		return idStateInd;
	}

	public void setIdStateInd(String idStateInd) {
		this.idStateInd = idStateInd;
	}

	public Date getIdUpdatEventDate() {
		return idUpdatEventDate;
	}

	public void setIdUpdatEventDate(Date idUpdatEventDate) {
		this.idUpdatEventDate = idUpdatEventDate;
	}

	public String getIdTxnType() {
		return idTxnType;
	}

	public void setIdTxnType(String idTxnType) {
		this.idTxnType = idTxnType;
	}
}
