package gov.va.med.ps.model;

import java.util.StringTokenizer;

/**
 * Value object to represent Patient Identifier.
 * @author DNS   kavurt
 *
 */
public class PatientIdentifier {

	String identity;
	/*
	 * PI , NI , SS etc
	 */
	String identityType ;
	
	String stationNumber;
	
	String assigningAuthority;
	
	private String idState = null; //CCR 11403

	public String getAssigningAuthority() {
		return assigningAuthority;
	}

	public void setAssigningAuthority(String assigningAuthority) {
		this.assigningAuthority = assigningAuthority;
	}

	public String getIdentity() {
		return identity;
	}

	public void setIdentity(String identity) {
		this.identity = identity;
	}

	public String getIdentityType() {
		return identityType;
	}

	public void setIdentityType(String identityType) {
		this.identityType = identityType;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}
	
	public String getIdState() {
		return idState;
	}

	public void setIdState(String idState) {
		this.idState = idState;
	}

	/**
	 * Defalut contructor.
	 *
	 */
	public PatientIdentifier(){
		
	}
	
	
	public PatientIdentifier(String identifierString){
		if ( identifierString != null ){
			StringTokenizer tokens = new StringTokenizer(identifierString, "^");
			
			int i=0;
			while ( tokens.hasMoreTokens()) {
				String token = tokens.nextToken();
				
				if ( i == 0 ) {
					setIdentity(token);
				} else if (i == 1 ) {
					setIdentityType(token);
				} else if (i == 2 ) {
					setStationNumber(token);
				} else if (i == 3 ) {
					setAssigningAuthority(token);
				} else if (i == 4 ) { //CCR 11403: added for idState
					setIdState(token);
				} 
				i++;
			}
		}
	}
}
