/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

import java.math.BigDecimal;

import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;

/**
 * Contains triggering information for the VOA entities.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class VOATriggerIdentity extends CommonTriggerIdentity
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 6323932558737638108L;

	private BigDecimal applicationId = null;
	
	private Person person = null;

    public VOATriggerIdentity()
    {
    }
    
    
    public VOATriggerIdentity(BigDecimal applicationId, Person person)
    {
        super(CommonTrigger.DestinationType.COMMON, null, CommonTrigger.DispatchType.PROCESS, CommonTrigger.EntityType.VOA);

    	this.applicationId = applicationId;
    	this.person = person;
    }

    public boolean matchTriggerCriteria(VOATriggerIdentity data)
    {
		boolean matchTriggerCriteria = false;
		if(getDestinationType().equals(data.getTargetType()) && 
				getDispatchType().equals(data.getDispatchType()) &&
				this.getEntityType().equals(data.getEntityType())) {
			matchTriggerCriteria = true;
		}
		return matchTriggerCriteria;    	
    }
    
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
    }

    protected String buildName()
    {
        return super.buildName();
    }

	public BigDecimal getApplicationId() {
		return applicationId;
	}


	public Person getPerson() {
		return person;
	}
}
