/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.trigger;

import java.math.BigDecimal;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.person.Person;

/**
 * VOA Trigger event for Web Service to forward the VOA event to common JMS queue and for ESR to retrieve and process VOA application
 * NOTE: the event must contain application id and person object
 * 
 * TODO: figure out the TargetType,DispatchType, EntityType
 * 
 * @author DNS   TSAIG
 */
public class VOATriggerEvent extends CommonTriggerEvent {

	private static final long serialVersionUID = 8272849730019891406L;



	public VOATriggerEvent(BigDecimal applicationId, Person person) {
		super(new VOATriggerIdentity(applicationId, person));
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
	}

}
