/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

// Java classes
import java.util.Set;

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.ee.IncomingMessageInfo;

/**
 * TriggerEvent that is targeted for certain VAFacility's.
 */
public class TargetedPersonTriggerEvent extends PersonTriggerEvent
{
    /**
     * 
     */
    private static final long serialVersionUID = -401439884772549081L;
    
    /**
     * Sites where the message should NOT be sent
     */
    private Set filterSites;
    
    /**
     * Sites where the message should  be sent.  Each site could be 
     * either an instance of VAFacility, or of SiteIdentity containing the 
     * site and the dfn.
     */
    private Set targetSites;
    
    private IncomingMessageInfo incomingMessageInfo = null;  

    public TargetedPersonTriggerEvent(PersonTrigger.DestinationType destinationType,
        PersonTrigger.TargetType targetType,
        PersonTrigger.DispatchType dispatchType,
        PersonTrigger.DataType dataType)
    {
        super(destinationType, targetType, dispatchType, dataType);
    }
    
    /**
     * Sites where the message should NOT be sent
     */
    public Set getFilterSites() {
		return filterSites;
	}

    /**
     * Sites where the message should NOT be sent
     */
    public void setFilterSites(Set filterSites) {
		this.filterSites = filterSites;
	}

	public Set getTargetSites() {
		return targetSites;
	}

	public void setTargetSites(Set targetSites) {
		this.targetSites = targetSites;
	}

	/**
     * @return Returns the incomingMessageInfo.
     */
    public IncomingMessageInfo getIncomingMessageInfo() {
        return incomingMessageInfo;
    }

    /**
     * @param incomingMessageInfo The incomingMessageInfo to set.
     */
    public void setIncomingMessageInfo(IncomingMessageInfo incomingMessageInfo) {
        this.incomingMessageInfo = incomingMessageInfo;
    }
    
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("targetSites", this.targetSites);
        builder.append("targetSites", this.filterSites);
        builder.append("incomingMessageInfo", this.incomingMessageInfo);        
    }
}
