package gov.va.med.esr.service.trigger;

import java.math.BigDecimal;

/**
 * TriggerEvent used for retransmission of specific messages based on the 
 * MessageLogEntry id.
 * 
 * @author Rajiv Patnaik
 * Created on Jan 10, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class RetransmitTriggerEvent extends CommonTriggerEvent
{
	private static final long serialVersionUID = 3726776976961342306L;
	
	private BigDecimal messageLogEntryId; 
    
	private boolean isSingleMessageRetransmitFromUI;
    
	public RetransmitTriggerEvent(BigDecimal messageLogEntryId, boolean isSingleMessageRetransmitFromUI) {
		super(new CommonTriggerIdentity(CommonTrigger.DestinationType.MESSAGING));
		this.messageLogEntryId = messageLogEntryId;
		this.isSingleMessageRetransmitFromUI = isSingleMessageRetransmitFromUI;
	}
    /**
     * @return Returns the messageLogEntryId.
     */
    public BigDecimal getMessageLogEntryId()
    {
        return messageLogEntryId;
    }
    
	public boolean isSingleMessageRetransmitFromUI() {
		return isSingleMessageRetransmitFromUI;
	}
    
    
    
}
