// Created Apr 28, 2005 10:20:55 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.trigger;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Contains triggering information for the event that is non-contextual.
 * 
 * @author DNS   BOHMEG
 */
public class PersonTriggerIdentity extends CommonTriggerIdentity {
	/**
	 * 
	 */
	private static final long serialVersionUID = 566526298204871099L;
	/** Can support more than one DataType.  Set<PersonTrigger.DataType> */
	private Set applicableDataTypes = null;
	
	//CCR 11402: a flag to see if Address & Phone Update to IdM is needed
	private boolean isIdMAddressPhoneUpdate = false;
	
  
	public PersonTriggerIdentity() {
	}

	public PersonTriggerIdentity(PersonTriggerIdentity triggerIdentity) {
		super((PersonTrigger.DestinationType) triggerIdentity.getDestinationType(),
				(PersonTrigger.TargetType) triggerIdentity.getTargetType(),
				(PersonTrigger.DispatchType) triggerIdentity.getDispatchType());
		applicableDataTypes = triggerIdentity.getApplicableDataTypes();
	}
	
	public PersonTriggerIdentity(PersonTrigger.DestinationType destinationType,
            PersonTrigger.TargetType targetType,
			PersonTrigger.DispatchType dispatchType,
			PersonTrigger.DataType dataType) {
		super(destinationType, targetType, dispatchType);
		applicableDataTypes = new HashSet(1);
		applicableDataTypes.add(dataType);
	}

	public PersonTriggerIdentity(PersonTrigger.DestinationType destinationType,
            PersonTrigger.TargetType targetType,
			PersonTrigger.DispatchType dispatchType, Set applicableDataTypes) {
		super(destinationType, targetType, dispatchType);
		this.applicableDataTypes = applicableDataTypes;
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("applicableDataTypes", applicableDataTypes);
	}

	protected String buildName() {
		return super.buildName() + NAME_DELIMITER
				+ buildApplicationDataTypesString();
	}

	private String buildApplicationDataTypesString() {
		StringBuffer buf = new StringBuffer();
		if (applicableDataTypes != null) {
			for (Iterator itr = applicableDataTypes.iterator(); itr.hasNext();) {
				buf.append(((PersonTrigger.DataType) itr.next()).getName());
			}
		} else {
			buf.append("NO_DATATYPE");
		}
		return buf.toString();
	}

	/**
	 * @return Returns the applicableDataTypes.
	 */
	public Set getApplicableDataTypes() {
		return applicableDataTypes;
	}

	/**
	 * @param applicableDataTypes
	 *            The applicableDataTypes to set.
	 */
	public void setApplicableDataTypes(Set applicableDataTypes) {
		this.applicableDataTypes = applicableDataTypes;
	}
	
	public boolean matchTriggerCriteria(PersonTriggerIdentity data) {
		boolean matchTriggerCriteria = false;
		if(getTargetType().equals(data.getTargetType()) && getDispatchType().equals(data.getDispatchType()) &&
				applicableDataTypes.containsAll(data.getApplicableDataTypes())) {
			matchTriggerCriteria = true;
		}
		return matchTriggerCriteria;
	}

	public boolean isIdMAddressPhoneUpdate() {
		return isIdMAddressPhoneUpdate;
	}

	public void setIdMAddressPhoneUpdate(boolean isIdMAddressPhoneUpdate) {
		this.isIdMAddressPhoneUpdate = isIdMAddressPhoneUpdate;
	}
}
