// Created Apr 28, 2005 10:23:03 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.trigger;

import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;


/**
 * Person centric triggered event.
 * 
 * @author DNS   BOHMEG
 */
public class PersonTriggerEvent extends CommonTriggerEvent {
	
    /**
	 * 
	 */
	private static final long serialVersionUID = -1722910688243745412L;

	private PersonEntityKey personId;
    
    private PersonIdentityTraits identityTraits;
    
    private PersonIdentityTraits onFileIdentityTraits;
 	
 	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.service.trigger.TriggerEvent#buildContextString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildContextString(ToStringBuilder builder) {
		super.buildContextString(builder);
		builder.append("personId", personId != null ? personId.getKeyValueAsString() : null);
	}

	public PersonTriggerEvent(PersonTrigger.DestinationType destinationType, PersonTrigger.TargetType targetType,
        PersonTrigger.DispatchType dispatchType, PersonTrigger.DataType dataType) {
		super(new PersonTriggerIdentity(destinationType, targetType, dispatchType, dataType));
	}

	public PersonTriggerEvent(PersonTrigger.DestinationType destinationType, PersonTrigger.TargetType targetType,
        PersonTrigger.DispatchType dispatchType, Set dataTypes) {
		super(new PersonTriggerIdentity(destinationType, targetType, dispatchType, dataTypes));
	}

    public PersonTriggerEvent(CommonTriggerIdentity commonTriggerIdentity)
    {
        super(commonTriggerIdentity);
    }
    
    public PersonTriggerEvent(String eventName) {
    	super(eventName);
    }

	/**
	 * @return Returns the personId.
	 */
	public PersonEntityKey getPersonId() {
		return personId;
	}

	
	public PersonIdentityTraits getIdentityTraits() {
		return identityTraits;
	}

	public void setIdentityTraits(PersonIdentityTraits identityTraits) {
		this.identityTraits = identityTraits;
	}

	public PersonIdentityTraits getOnFileIdentityTraits() {
		return onFileIdentityTraits;
	}

	public void setOnFileIdentityTraits(PersonIdentityTraits onFile) {
		
		//CCR12311 - remove POB
		if (onFile.getBirthRecord() != null)
		{
			onFile.getBirthRecord().setCity(null);
			onFile.getBirthRecord().setState(null);
			onFile.getBirthRecord().setCountry(null);
		}
		
		this.onFileIdentityTraits = onFile;
	}
	
	/**
	 * @param personId The personId to set.
	 */
	public void setPersonId(PersonEntityKey personId) {
		this.personId = personId;
	}
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("personId", personId);
	}	
	
	/** Custom implementation */
	protected void preTrigger() {
		if(personId != null)
			personId.disableVersionCheck();
	}
}
