// Created Apr 28, 2005 9:48:43 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.trigger;

import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.enums.EnumUtils;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;


/**
 * Any application component that can trigger Person events needs to implement this interface
 * and manage the set of TriggerEvents.
 * 
 * @author DNS   BOHMEG
 */
public interface PersonTrigger extends CommonTrigger {	
	
	/** Contains all known data types for Person TriggerEvents */
	public class DataType extends Enum {
		/**
		 * 
		 */
		private static final long serialVersionUID = 7355544962121679799L;
		public static final DataType BULLETIN = new DataType("BULLETIN");
		public static final DataType WORKFLOW = new DataType("WORKFLOW");
		public static final DataType FULL_DATA = new DataType("FULL_DATA");
		public static final DataType ELIGIBILITY = new DataType("ELIGIBILITY");
		public static final DataType FINANCIAL = new DataType("FINANCIAL");
		public static final DataType ADDRESS = new DataType("ADDRESS");
		public static final DataType PHONE = new DataType("PHONE");
		public static final DataType EMAIL = new DataType("EMAIL");
		public static final DataType DATE_OF_DEATH = new DataType("DATE_OF_DEATH");
		public static final DataType GUARDIAN_INFO = new DataType("GUARDIAN_INFO");
		public static final DataType SPOUSE_DEPENDENTS_SSN_VALIDATION_INFO = new DataType("SPOUSE_DEPENDENTS_SSN_VALIDATION_INFO");
		public static final DataType INSURANCE = new DataType("INSURANCE");
        public static final DataType MEANS_TEST = new DataType("MEANS_TEST");        
        public static final DataType RX_TEST = new DataType("RX_TEST");
        public static final DataType VOA = new DataType("VOA");        
        
        
        
        private DataType(String name) { super(name); }
		
		public static DataType getDataType(String code) {
			return (DataType) EnumUtils.getEnum(PersonTrigger.DataType.class, code);			
		}
	}
	
	/** Gets a Person id */
	public PersonEntityKey getPersonId();
}
