/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;

/**
 * Encapsulates data needed to create a JMS message containing message case-related data.  A person Id needs to be
 * set in the base class.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class MessageCaseTriggerEvent extends PersonTriggerEvent
{
    /**
	 * 
	 */
	private static final long serialVersionUID = -1489667201881072313L;
	private WorkflowCaseInfo workflowCaseInfo = null;

    /**
     * Constructs a Message Case Trigger Event.
     */
    public MessageCaseTriggerEvent()
    {
        super(new CommonTriggerIdentity(
            PersonTrigger.DestinationType.COMMON, null, PersonTrigger.DispatchType.CREATE));
    }

	public WorkflowCaseInfo getWorkflowCaseInfo() {
		return this.workflowCaseInfo;
	}

	public void setWorkflowCaseInfo(WorkflowCaseInfo workflowCaseInfo) {
		this.workflowCaseInfo = workflowCaseInfo;
	}
}