/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;

/**
 * Contains triggering information for the letter entities.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class LetterTriggerIdentity extends CommonTriggerIdentity
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 6323932558737638108L;
	private ComLetterTemplateType dataType;
    private LetterTrigger.CategoryType categoryType = LetterTrigger.CategoryType.VETERAN_LETTER; // default

    public LetterTriggerIdentity()
    {
    }

    public LetterTriggerIdentity(ComLetterTemplateType dataType)
    {
        super(PersonTrigger.DestinationType.COMMON, null, PersonTrigger.DispatchType.SEND);
        this.dataType = dataType;
    }    
    
    public LetterTriggerIdentity(ComLetterTemplateType dataType, LetterTrigger.CategoryType categoryType)
        {
            super(PersonTrigger.DestinationType.COMMON, null, PersonTrigger.DispatchType.SEND);
            this.dataType = dataType;
            this.categoryType = categoryType;
        }
    
    
    public LetterTriggerIdentity(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType,
        CommonTrigger.DispatchType dispatchType, ComLetterTemplateType dataType, LetterTrigger.CategoryType categoryType)
    {
        super(destinationType, targetType, dispatchType);
        this.dataType = dataType;
        this.categoryType = categoryType;
    }

    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("dataType", dataType != null ? dataType.getCode() : null);
    }

    protected String buildName()
    {
        return super.buildName() + NAME_DELIMITER + dataType == null ? "NO_DATATYPE" : dataType.getName();
    }

    public ComLetterTemplateType getDataType()
    {
        return dataType;
    }

    public void setDataType(ComLetterTemplateType dataType)
    {
        this.dataType = dataType;
    }

	/**
	 * @return Returns the categoryType.
	 */
	public LetterTrigger.CategoryType getCategoryType() {
		return categoryType;
	}

	/**
	 * @param categoryType The categoryType to set.
	 */
	public void setCategoryType(LetterTrigger.CategoryType categoryType) {
		this.categoryType = categoryType;
	}
}
