/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;


import java.util.Date;

import org.apache.commons.lang.enums.Enum;

import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComMailingTriggerType;


/**
 * Encapsulates data needed to create a JMS message containing letter-related data.  A person Id needs to be
 * set in the base class.  The dataType in the constructor specifies which form number is to be sent.
 * An optional workflow case Id and mail type may be specified.  A mail type of AUTO_MAIL will be used if no
 * mail type is specified.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class LetterTriggerEvent extends PersonTriggerEvent
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 7004506913219314805L;

	private String workflowCaseId = null;
	
	private String ivmCaseNumber = null;	

	private Date ivmCaseClosureDate = null;

    private MailType mailType = AUTO_MAIL;

    /** Manual Mail Type */
    public static final MailType MANUAL_MAIL = new MailType(ComMailingTriggerType.COM_MAILING_TRIGGER_MANUAL.getCode());

    /** Remail Mail Type */
    public static final MailType REMAIL_MAIL = new MailType(ComMailingTriggerType.COM_MAILING_TRIGGER_REMAIL.getCode());

    /** Historic Mail Type */
    public static final MailType HISTORIC_MAIL = new MailType(ComMailingTriggerType.COM_MAILING_TRIGGER_HISTORICAL.getCode());

    /** Auto Mail Type */
    public static final MailType AUTO_MAIL = new MailType(ComMailingTriggerType.COM_MAILING_TRIGGER_AUTOMATIC.getCode());

    /**
     * Contains the various mail types to send.
     */
    public static class MailType extends Enum
    {
        /**
		 * 
		 */
		private static final long serialVersionUID = -8920303816982967700L;

		private MailType(String type)
        {
            super(type);
        }
    }

    /**
     * Constructs a letter trigger event with a data type.
     *
     * @param dataType The letter data type.
     */
    public LetterTriggerEvent(ComLetterTemplateType dataType)
    {
    	this(dataType, LetterTrigger.CategoryType.VETERAN_LETTER);
    }

    public LetterTriggerEvent(ComLetterTemplateType dataType, LetterTrigger.CategoryType categoryType)
    {
        super(new LetterTriggerIdentity(dataType, categoryType));
    }
    
    public String getWorkflowCaseId()
    {
        return workflowCaseId;
    }

    public void setWorkflowCaseId(String workflowCaseId)
    {
        this.workflowCaseId = workflowCaseId;
    }

    public MailType getMailType()
    {
        return mailType;
    }

    public void setMailType(MailType mailType)
    {
        this.mailType = mailType;
    }

	public String getIvmCaseNumber() {
		return ivmCaseNumber;
	}

	public void setIvmCaseNumber(String ivmCaseNumber) {
		this.ivmCaseNumber = ivmCaseNumber;
	}

	public Date getIvmCaseClosureDate() {
		return ivmCaseClosureDate;
	}

	public void setIvmCaseClosureDate(Date ivmCaseClosureDate) {
		this.ivmCaseClosureDate = ivmCaseClosureDate;
	}
    
}