/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.trigger;

import gov.va.med.esr.common.model.financials.IncomeTest;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Initial javadoc for class IncomeYearTriggerEvent.
 * TODO - Add content here
 * 
 * Created Sep 2, 2005 1:30:55 AM
 * @author DNS   BOHMEG
 */
public class IncomeYearTriggerEvent extends TargetedPersonTriggerEvent {
	/**
	 * 
	 */
	private static final long serialVersionUID = -5437802582009167654L;
	private Integer incomeYear;
    private IncomeTest deletedIncomeTest;
    private String actionCode;    
    private String type;    
    private String reversalType;
    
    

    public IncomeYearTriggerEvent(PersonTrigger.DestinationType destinationType,
            PersonTrigger.TargetType targetType,
            PersonTrigger.DispatchType dispatchType,
            PersonTrigger.DataType dataType) {
        super(destinationType, targetType, dispatchType, dataType);
    }
    
    public static IncomeYearTriggerEvent notifyVistaForFinancial(Integer incomeYear) {
        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.FINANCIAL);

       incomeYearTriggerEvent.setIncomeYear(incomeYear);
       return incomeYearTriggerEvent;
    }
    
    public static IncomeYearTriggerEvent notifyVistaForFinancial(Integer incomeYear, IncomeTest deletedIncomeTest) {
        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.FINANCIAL);

       incomeYearTriggerEvent.setIncomeYear(incomeYear);
       incomeYearTriggerEvent.setDeletedIncomeTest(deletedIncomeTest);
       return incomeYearTriggerEvent;
    }
    
	/**
	 * @return Returns the incomeYear.
	 */
	public Integer getIncomeYear() {
		return incomeYear;
	}

	/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(Integer incomeYear) {
		this.incomeYear = incomeYear;
	}

	public IncomeTest getDeletedIncomeTest() {
        return deletedIncomeTest;
    }

    public void setDeletedIncomeTest(IncomeTest deletedIncomeTest) {
        this.deletedIncomeTest = deletedIncomeTest;
    }

    protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("incomeYear", this.incomeYear);
	}

	public String getActionCode() {
		return actionCode;
	}

	public void setActionCode(String actionCode) {
		this.actionCode = actionCode;
	}	

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getReversalType() {
		return reversalType;
	}

	public void setReversalType(String reversalType) {
		this.reversalType = reversalType;
	}	
}
