/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.trigger;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.ee.EGTSetting;

/**
 * Initial javadoc for class EGTTriggerEvent. TODO - Add content here
 * 
 * @author DNS   BOHMEG Created Jun 22, 2005 1:51:01 PM
 */
public class EGTTriggerEvent extends CommonTriggerEvent {
	/**
	 * 
	 */
	private static final long serialVersionUID = -723111889251639552L;
	private EGTSetting EGTSetting;	

	public EGTTriggerEvent(EGTSetting EGTSetting) {
		super(new CommonTriggerIdentity(CommonTrigger.DestinationType.MESSAGING,
            CommonTrigger.TargetType.VISTA,
            CommonTrigger.DispatchType.NOTIFY,
			CommonTrigger.EntityType.EGT));
		this.EGTSetting = EGTSetting;
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("EGTSetting", EGTSetting);
	}

	/**
	 * @return Returns the eGTSetting.
	 */
	public EGTSetting getEGTSetting() {
		return EGTSetting;
	}

	/**
	 * @param setting The eGTSetting to set.
	 */
	public void setEGTSetting(EGTSetting setting) {
		EGTSetting = setting;
	}
}
