/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

// Java classes

// Library classes
import gov.va.med.fw.service.trigger.AbstractTriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerIdentity;

// ESR classes

/**
 * Contains event information that is not specific to the context of the event.
 * 
 * @author DNS   BOHMEG
 */
public class CommonTriggerIdentity extends AbstractTriggerIdentity {
	/**
	 * 
	 */
	private static final long serialVersionUID = 8853783928394725554L;

	public CommonTriggerIdentity() {}

	public CommonTriggerIdentity(TriggerIdentity.DestinationType destinationType) {
		super(destinationType);
	}	
	
	public CommonTriggerIdentity(CommonTrigger.DestinationType destinationType) {
		super(destinationType);
	}	
	public CommonTriggerIdentity(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType,
			CommonTrigger.DispatchType dispatchType) {
		super(destinationType, targetType, dispatchType);
	}

	public CommonTriggerIdentity(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType,
			CommonTrigger.DispatchType dispatchType,
			CommonTrigger.EntityType entityType) {
		super(destinationType, targetType, dispatchType, entityType);
	}

    /**
     * @param triggerIdentity
     * @return
     */
    public boolean matchTriggerCriteria(CommonTriggerIdentity data)
    {
		boolean matchTriggerCriteria = false;
		if(getTargetType().equals(data.getTargetType()) && getDispatchType().equals(data.getDispatchType()) ) {
			matchTriggerCriteria = true;
		}
		return matchTriggerCriteria;    	
    }
}
