/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

// Java classes

// Library classes

// Framework classes
import java.io.Serializable;

import gov.va.med.fw.service.trigger.TriggerEvent;

// ESR classes

/**
 * Common representation of a TriggerEvent. This maps to a specific piece of
 * data being consumed by a receiving target.
 * 
 * @author DNS   BOHMEG
 */
public class CommonTriggerEvent extends TriggerEvent {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6344550442423003911L;

	public CommonTriggerEvent(String name) {
		super(name, new CommonTriggerIdentity(CommonTrigger.DestinationType.COMMON));
	}

	public CommonTriggerEvent(String name, Serializable payload, CommonTriggerIdentity triggerIdentity) {
		super(name, payload, triggerIdentity); 
	}
	
	public CommonTriggerEvent(CommonTriggerIdentity triggerIdentity) {
		super(triggerIdentity); 
	}
	
	public CommonTriggerEvent(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType,
			CommonTrigger.DispatchType dispatchType) {
		super(new CommonTriggerIdentity(destinationType, targetType, dispatchType));
	}
}
