// Created Apr 28, 2005 10:13:04 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.trigger;

import gov.va.med.fw.service.trigger.TriggerAware;
import gov.va.med.fw.service.trigger.TriggerIdentity;

/**
 * Any application component that can trigger events to known targets needs to implement this interface
 * and manage the set of TriggerEvents.
 * 
 * @author DNS   BOHMEG
 */
public interface CommonTrigger extends TriggerAware {
	/** Contains all known targets for targeted TriggerEvents */
	public class TargetType extends TriggerIdentity.TargetType {
		/**
		 * 
		 */
		private static final long serialVersionUID = 236006596299458720L;
		public static final TargetType VBA = new TargetType("VBA");
		public static final TargetType VISTA = new TargetType("VISTA");
		public static final TargetType MHV = new TargetType("MHV");
		private TargetType(String name) { super(name); }
	}

    /** Contains all known destinations for targeted TriggerEvents */
    public class DestinationType extends TriggerIdentity.DestinationType {
    	/**
		 * 
		 */
		private static final long serialVersionUID = -5210249998394281269L;
		public static final DestinationType COMMON = new DestinationType("COMMON");
        public static final DestinationType MESSAGING = new DestinationType("MESSAGING");
        public static final DestinationType MESSAGING_BATCH_PROCESS = new DestinationType("MESSAGING_BATCH_PROCESS");
        private DestinationType(String name) { super(name); }
    }

	/** Contains all known dispatch types for Common TriggerEvents */
	public class DispatchType extends TriggerIdentity.DispatchType {
		/**
		 * 
		 */
		private static final long serialVersionUID = 5502407310085135933L;
		/** Corresponds to a query message */
		public static final DispatchType QUERY = new DispatchType("QUERY");
		/** Corresponds to sending a message that targets are expecting (non-query response) */
		public static final DispatchType RESPOND = new DispatchType("RESPOND");
		/** Corresponds to sending a message that targets are not expecting */
		public static final DispatchType NOTIFY = new DispatchType("NOTIFY");
        public static final DispatchType SEND = new DispatchType("SEND");
        public static final DispatchType CREATE = new DispatchType("CREATE");
        public static final DispatchType INITIATE = new DispatchType("INITIATE");
        public static final DispatchType PROCESS = new DispatchType("PROCESS"); //added for VOA
		private DispatchType(String name) { super(name); }
	}
	
	/** Contains all known entity types for Common TriggerEvents */
	public class EntityType extends TriggerIdentity.EntityType {
		/**
		 * 
		 */
		private static final long serialVersionUID = 4540463643920922254L;
		/** Corresponds to a query message */
		public static final EntityType EGT = new EntityType("EGT");
        public static final EntityType LETTER = new EntityType("LETTER");
        public static final EntityType BULLETIN = new EntityType("BULLETIN");
        public static final EntityType MESSAGE_CASE = new EntityType("MESSAGE CASE");
        public static final EntityType BATCH_JOB = new EntityType("BATCH JOB");
        public static final EntityType VOA = new EntityType("VOA"); //for VOA
		private EntityType(String name) { super(name); }
	}
}
