/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.trigger;

import java.util.List;

import org.apache.commons.lang.time.DateUtils;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;

/**
 * Initial javadoc for class ClockTriggerEvent.
 * TODO - Add content here
 * 
 * Created Dec 5, 2006 10:16:43 AM
 * @author DNS   BOHMEG
 */
public class ClockTriggerEvent extends PersonTriggerEvent {
	/**
	 * 
	 */
	private static final long serialVersionUID = -5262693326968221439L;
	public static final String CANCEL_CLOCK = "triggerEvent.cancelClock";
	public static final String START_CLOCK = "triggerEvent.startClock";
	
	private String triggerName;
	private String triggerGroup;
	private String jobDetailBeanName;
	private double hoursDelay;
	private List clockData;
	
	public ClockTriggerEvent(String clockName, PersonEntityKey personId) {
		super(new CommonTriggerIdentity( CommonTrigger.DestinationType.COMMON ));
		setName(clockName);
		super.setPersonId(personId);
	}

	/**
	 * @return Returns the clockData.
	 */
	public List getClockData() {
		return clockData;
	}

	/**
	 * @param clockData The clockData to set.
	 */
	public void setClockData(List clockData) {
		this.clockData = clockData;
	}

	/**
	 * @return Returns the hoursDelay.
	 */
	public double getHoursDelay() {
		return hoursDelay;
	}

	/**
	 * @param hoursDelay The hoursDelay to set.
	 */
	public void setHoursDelay(double hoursDelay) {
		this.hoursDelay = hoursDelay;
	}

	/**
	 * @return Returns the triggerGroup.
	 */
	public String getTriggerGroup() {
		return triggerGroup;
	}

	/**
	 * @param triggerGroup The triggerGroup to set.
	 */
	public void setTriggerGroup(String triggerGroup) {
		this.triggerGroup = triggerGroup;
	}

	/**
	 * @return Returns the triggerName.
	 */
	public String getTriggerName() {
		return triggerName;
	}

	/**
	 * @param triggerName The triggerName to set.
	 */
	public void setTriggerName(String triggerName) {
		this.triggerName = triggerName;
	}

	/**
	 * @return Returns the jobDetailBeanName.
	 */
	public String getJobDetailBeanName() {
		return jobDetailBeanName;
	}

	/**
	 * @param jobDetailBeanName The jobDetailBeanName to set.
	 */
	public void setJobDetailBeanName(String jobDetailBeanName) {
		this.jobDetailBeanName = jobDetailBeanName;
	}
	
	/** Adjusts the hour delay to take into account the amount of "wait" time from when this
	 * clock (time-based) event was created.
	 * 
	 * @return
	 */
	public double getAdjustedHoursDelay() {
		long effectiveClockStartTime = this.getCreationDate();
		if(effectiveClockStartTime == 0)
			return this.getHoursDelay(); // nothing more we can do...
		
		long difference = System.currentTimeMillis() - effectiveClockStartTime;
		double hoursToRemoveFromDelay = difference / DateUtils.MILLIS_PER_HOUR;
		if(hoursToRemoveFromDelay < 1.0)
			return this.getHoursDelay(); // ignore this immaterial difference
		else if(hoursToRemoveFromDelay >= this.getHoursDelay())
			return 0;
		
		return this.getHoursDelay() - hoursToRemoveFromDelay;
	}
}
