/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Contains triggering information for the bulletin entities.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class BulletinTriggerIdentity extends CommonTriggerIdentity
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 5933736178195622623L;
	private BulletinTrigger.DataType dataType;

    public BulletinTriggerIdentity()
    {
    }

    public BulletinTriggerIdentity(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType,
        CommonTrigger.DispatchType dispatchType, BulletinTrigger.DataType dataType)
    {
        super(destinationType, targetType, dispatchType);
        this.dataType = dataType;
    }

    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("dataType", dataType);
    }

    protected String buildName()
    {
        return super.buildName() + NAME_DELIMITER + dataType == null ? "NO_DATATYPE" : dataType.getName();
    }

    public BulletinTrigger.DataType getDataType()
    {
        return dataType;
    }

    public void setDataType(BulletinTrigger.DataType dataType)
    {
        this.dataType = dataType;
    }
}
