/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.trigger;

// Java classes
import java.util.Hashtable;
import java.util.Set;
import java.util.Map;
import java.util.Collections;

// Library classes

// Framework classes

// ESR classes

/**
 * Encapsulates data needed to create a JMS message containing bulletin-related data.  A person Id needs to be
 * set in the base class.  The dataType in the constructor specifies which bulletin is to be sent.
 * Various field/value pairs can be added based on the form specified.  Use the interfaces within this
 * class for the field names.  If a form doesn't take any fields, an interface won't be defined.
 * <p/>
 * Project: Common</br> Created on: 11:11:05 PM </br>
 *
 * @author DNS   LEV
 * @author Andrew Pach
 * @version 3.0
 */
public class BulletinTriggerEvent extends PersonTriggerEvent
{
	public static final String STATION_NUMBER = "SITE";
    
		
    /**
     * List of fields for the HecNotifyApplicationConversionComplete.
     */
    public interface HecNotifyApplicationConversionComplete
    {
        public static final String CANCELDECLINE_COUNT = "canceldeclineCount";
        public static final String REJECTED_COUNT = "rejectedCount";        
    }	
	
    /**
     * List of fields for the HecNotifyBadAddressField.
     */
    public interface HecNotifyBadAddressField
    {
        public static final String BAD_ADDRESS_REASON = "BadAddressRsn";
    }    
    
    /**
     * List of fields for the HecNotifyServiceConnectedPercentageChangeField.
     */
    public interface HecNotifyServiceConnectedPercentageChangeField
    {
        public static final String DATE_OF_CHANGE = "DateOfChange";
        public static final String SC_CHANGED_FROM = "SCChangedFrom";
        public static final String SC_CHANGED_TO = "SCChangedTo";
    }

    /**
     * List of fields for the HecNotifyVaPensionStatusChangeField.
     */
    public interface HecNotifyVaPensionStatusChangeField
    {
        public static final String DATE_OF_CHANGE = "DateOfChange";
        public static final String PENSION_IND_CHANGED_FROM = "PensionIndChangedFrom";
        public static final String PENSION_IND_CHANGED_TO = "PensionIndChangedTo";
    }

    /**
     * List of fields for the HecNotifyRatedDisabilityAddedField.
     */
    public interface HecNotifyRatedDisabilityAddedField
    {
        public static final String DATE_OF_CHANGE = "DateOfChange";
        public static final String SC_CODES_AND_DESCRIPTIONS_ADDED = "SCCodesAndDescriptionsAdded";
    }

    /**
     * List of fields for the HecNotifyRatedDisabilityRemovedField.
     */
    public interface HecNotifyRatedDisabilityRemovedField
    {
        public static final String DATE_OF_CHANGE = "DateOfChange";
        public static final String SC_CODES_AND_DESCRIPTIONS_REMOVED = "SCCodesAndDescriptionsRemoved";
    }

    /**
     * List of fields for the HecNotifyPurplseHeartNoDecision.
     */
    public interface HecNotifyPurplseHeartNoDecision
    {
        public static final String EFFECTIVE_DATE = "EffectiveDate";
        public static final String REJECTED_REMARK = "RejectedRemark";
    }

    /**
     * List of fields for the HecNotifySiteVeteranVerification.
     */
    public interface HecNotifySiteVeteranVerification
    {
        public static final String PREFERRED_FACILITY = "PreferredFacility";
        public static final String SITES_VETERAN_VISITED = "SitesVeteranVisited";
    }

    /**
     * List of fields for the HecNotifyPowDiscrepancyNotMatch.
     */
    public interface HecNotifyPowDiscrepancyNotMatch
    {
        public static final String POW_FROM_DATE = "PowFromDate";
        public static final String POW_TO_DATE = "PowToDate";
        public static final String POW_CONFINEMENT_LOCATION = "PowConfinementLocation";
        public static final String POW_EPISODES= "POWEpisodes";
    }


    /**
     * List of fields for the NotifySignatureInError.
     */
    public interface NotifySignatureInError
    {
        public static final String STATION_ID = "StationId";
        public static final String IMAGE_INDEX_NUMBER = "ImageIndexNumber";
    }

    public interface HecNotifySsaRecordNotMatchHecInternalId
    {
    }    
    
    //Common fields used by different bulletins
    public interface PersonIdentityFields
    {
    	public static final String VPID = "VPID";
    }
    
    public interface InconsistentConflictDatafromSite
    {
    	public static final String OEFOIF_EPISODES= "OEIFEpisodes";
    }
    
    public interface VOASpinalCordFields
    {
    	public static final String VPID = "VPID";
    	public static final String DFN = "DFN";
    	public static final String STATION_ID = "StationNumber";
    	public static final String PREFERRED_FACILITY = "PreferredFacility";
    }
    
    public interface HecNotificationOfTerminatedVAPensionSC
    {
    	public static final String SC_PERCENTAGE= "XX";
    }
    
    public interface HecNotifyPersonAddedFields
    {
    	public static final String VPID = "VPID";
    	public static final String DFN = "DFN";
    	public static final String STATION_ID = "STN";
    	public static final String PREFERRED_FACILITY = "SITE NAME";
    }

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -1212656129408570235L;

    // The data table of fields to values needed by CommsEmailBulletinService.sendEmailBulletin.
    private Hashtable dataTable = new Hashtable();

    /**
     * Constructs a bulletin trigger event with a data type.
     *
     * @param dataType The bulletin data type.
     */
    public BulletinTriggerEvent(BulletinTrigger.DataType dataType)
    {
        super(new BulletinTriggerIdentity(
            PersonTrigger.DestinationType.COMMON, null, PersonTrigger.DispatchType.SEND, dataType));
    }

    /**
     * @deprecated Description is not supported.  Use constructor that takes a dataType.
     */
    public BulletinTriggerEvent(String description)
    {
        super(new BulletinTriggerIdentity(
            PersonTrigger.DestinationType.COMMON, null, PersonTrigger.DispatchType.SEND, null));
    }

    /**
     * @deprecated Description is not supported.  Use constructor that takes a dataType.
     */
    public BulletinTriggerEvent(int letterNumber)
    {
        super(new BulletinTriggerIdentity(
            PersonTrigger.DestinationType.COMMON, null, PersonTrigger.DispatchType.SEND, null));
    }

    /**
     * Adds a field and value to the data table.
     *
     * @param field The field.  One of the fields of a particular form interface in this class should be used.
     * @param value The value for the field.
     */
    public void addField(String field, Object value)
    {
        dataTable.put(field, value);
    }

    /**
     * Removes a field from the data table.
     *
     * @param field The field to remove.
     */
    public void removeField(String field)
    {
        dataTable.remove(field);
    }

    /**
     * Removes all fields from the data table.
     */
    public void removeAllFields()
    {
        dataTable.clear();
    }

    /**
     * Gets a value for the specified field from the data table.
     *
     * @param field The field to retrieve.
     */
    public Object getField(String field)
    {
        return dataTable.get(field);
    }

    /**
     * Gets the field key set.
     *
     * @return The field key set.
     */
    public Set getFieldKeySet()
    {
        return dataTable.keySet();
    }

    /**
     * Gets the unmodifiable field map.
     *
     * @return The field map.
     */
    public Map getFieldMap()
    {
        return Collections.unmodifiableMap(dataTable);
    }
}