/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.service.impl;

// Java Classes

// Library Classes
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;

import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;

import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.trigger.MessageCaseTriggerEvent;

/**
 * This class processes a Workflow New Message Case trigger event message by preparing any needed data and calling the
 * appropriate workflow service API.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class WorkflowNewMessageCaseProcessor extends AbstractComponent implements TriggerableService
{
    private WorkflowService workflowService = null;

    /**
     * Process the MessageCaseTriggerEvent.
     *
     * @param triggerEvent The trigger event
     *
     * @throws gov.va.med.fw.service.ServiceException If there were any problems encountered.
     */
    public void trigger(TriggerEvent triggerEvent) throws ServiceException
    {
        if (this.logger.isDebugEnabled())
        {
            this.logger.debug("Received a trigger event " + triggerEvent);
        }

        // Get the specific trigger event
        MessageCaseTriggerEvent messageCaseTriggerEvent = (MessageCaseTriggerEvent)triggerEvent;

        // Build the NewMessageCaseDTO from the payload of the message
        WorkflowCaseInfo workflowCaseInfo = messageCaseTriggerEvent.getWorkflowCaseInfo();

        // Call the service to create the case.    
        if (workflowCaseInfo != null) 
        	getWorkflowService().autoCreateCase(workflowCaseInfo);
    }

    /**
     * Verify that the required properties are set.
     */
    public void afterPropertiesSet()
    {
        if (workflowService == null)
        {
            throw new InvalidConfigurationException("workflowService must be set on "
                + getClass().getName());
        }
    }

    public WorkflowService getWorkflowService() {
        return workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}
