/********************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.comms.GeocodeTransmit;
import gov.va.med.esr.common.model.comms.VCDeterminationHistoryForm;
import gov.va.med.esr.common.model.comms.Waittime;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.comms.GeocodeTransmitDAO;
import gov.va.med.esr.common.persistent.comms.WaittimeDAO;
import gov.va.med.esr.service.VeteransChoiceInformationService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.math.BigDecimal;
import java.util.List;
// Java Classes


/**
 * Class that implements Preferred Facility services
 */
public class VeteransChoiceInformationServiceImpl extends AbstractRuleAwareServiceImpl implements VeteransChoiceInformationService {


	/**
	 * 
	 */
	private static final long serialVersionUID = 6586116108353074551L;
	
	private GeocodeTransmitDAO geocodeTransmitDAO;
	private WaittimeDAO waittimeDAO;

	/**
	 * get the most current Geocode Transmit record processed by PSSG transaction
	 * @param incoming person
	 * @return most recent Geocode Transmit record for Veteran
	 * @throws ServiceException
	 */
	@Override
	public GeocodeTransmit fetchGeocodeTransmitRecord(Person person) throws ServiceException {
		BigDecimal personId = (BigDecimal) person.getPersonEntityKey().getKeyValue();
		List geocodeTransmits = null;

		try {
			geocodeTransmits = geocodeTransmitDAO.findGeocodeTransmitByPersonId(personId);
		} catch (DAOException ex) {
			throw new ServiceException(
					"Failed to find delivery preference based on person ICN: "
							+ person.getVPIDValue(), ex);
		}
		// query returns a descending order on primary key so
		// return first list element to get the latest record
		if (geocodeTransmits != null && geocodeTransmits.size() > 0) {
			return (GeocodeTransmit) geocodeTransmits.get(0);
		} else {
			return null;
		}
}

	/**
	 * get the most current Waittime record processed by CDW transaction
	 * @param incoming person
	 * @return most recent Waittime record for Veteran
	 * @throws ServiceException
	 */
	@Override
	public Waittime fetchWaittimeRecord(Person person) throws ServiceException {
		BigDecimal personId = (BigDecimal) person.getPersonEntityKey().getKeyValue();
		List waittimes = null;

		try {
			waittimes = waittimeDAO.findWaittimeByPersonId(personId);
		} catch (DAOException ex) {
			throw new ServiceException(
					"Failed to find Waittime based on person ICN: "
							+ person.getVPIDValue(), ex);
		}
		// query returns a descending order on primary key so
		// return first list element to get the latest record
		if (waittimes != null && waittimes.size() > 0) {
			return (Waittime) waittimes.get(0);
		} else {
			return null;
		}
	}

	/**
	 * get all Waittime records processed by CDW transaction
	 * @param incoming person
	 * @return all Waittime records for Veteran
	 * @throws ServiceException
	 */
	@Override
	public List fetchAllWaittimeRecords(Person person) throws ServiceException {
		BigDecimal personId = (BigDecimal) person.getPersonEntityKey().getKeyValue();
		List waittimes = null;

		try {
			waittimes = waittimeDAO.findWaittimeByPersonId(personId);
		} catch (DAOException ex) {
			throw new ServiceException(
					"Failed to find Waittime based on person ICN: "
							+ person.getVPIDValue(), ex);
		}
		// query returns a descending order on primary key
		return waittimes;
	}
	
	public List fetchVCChangeTimeLog(Person person) throws ServiceException {
		BigDecimal personId = (BigDecimal) person.getPersonEntityKey().getKeyValue();
		List waittimes = null;

		try {
			waittimes = waittimeDAO.findVCChangeTimeLog(personId);
		} catch (DAOException ex) {
			throw new ServiceException(
					"Failed to find VCChangeTimeLog based on person id: "
							+ personId, ex);
		}
		// query returns a descending order on primary key
		return waittimes;
	}

	public GeocodeTransmitDAO getGeocodeTransmitDAO() {
		return geocodeTransmitDAO;
	}

	public void setGeocodeTransmitDAO(GeocodeTransmitDAO geocodeTransmitDAO) {
		this.geocodeTransmitDAO = geocodeTransmitDAO;
	}

	public WaittimeDAO getWaittimeDAO() {
		return waittimeDAO;
	}

	public void setWaittimeDAO(WaittimeDAO waittimeDAO) {
		this.waittimeDAO = waittimeDAO;
	}

	@Override
	public VCDeterminationHistoryForm fetchVCDeterminationHistory(String input)
			throws ServiceException {
		VCDeterminationHistoryForm history = null;
		try {
			history = waittimeDAO.findVCDeterminationHistory(input);
		} catch (DAOException ex) {
			throw new ServiceException(
					"Failed to find VC Hisotry based on time stamp: "
							+ input, ex);
		}
		// query returns a descending order on primary key
		return history;
	}

}
