/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
 
package gov.va.med.esr.service.impl;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;

import gov.va.med.esr.service.VOAApplicationService;
import gov.va.med.esr.service.trigger.VOATriggerEvent;
import gov.va.med.esr.service.trigger.VOATriggerIdentity;

/**
 * This class processes a letter trigger event message by preparing any needed
 * data and calling the appropriate letter service API.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class VOAApplicationMessageProcessor extends AbstractComponent implements TriggerableService {

	private VOAApplicationService voaApplicationService = null;

	/**
	 * Process the LetterTriggerEvent.
	 * 
	 * @param triggerEvent
	 *           The trigger event
	 * @throws ServiceException
	 *            If there were any problems encountered.
	 */
	public void trigger(TriggerEvent triggerEvent) throws ServiceException {
		
		if( this.logger.isDebugEnabled() ) {
			this.logger.debug( "Received a trigger event " + triggerEvent );
		}
		
		VOATriggerEvent voaEvent = (VOATriggerEvent) triggerEvent;

		// Get the voa trigger identity
		VOATriggerIdentity voaTriggerIdentity = (VOATriggerIdentity) voaEvent
				.getTriggerIdentity();
		
		// Get the applicationId and person stored in the trigger identity in the event
		// and call VOAApplicationService to processVOA
		this.getVoaApplicationService().processVoaApplication(voaTriggerIdentity.getApplicationId(), voaTriggerIdentity.getPerson());
	}

	/**
	 * Verify that the required properties are set.
	 */
	public void afterPropertiesSet() {
		if (voaApplicationService == null) {
			throw new InvalidConfigurationException(
					"VOAApplicationService must be set on " + getClass().getName());
		}
	}

	public VOAApplicationService getVoaApplicationService() {
		return voaApplicationService;
	}

	public void setVoaApplicationService(VOAApplicationService voaApplicationService) {
		this.voaApplicationService = voaApplicationService;
	}

}
