package gov.va.med.esr.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.VHICCardInfoService;
import gov.va.med.esr.service.external.VHICCardInfo;
import gov.va.med.esr.service.external.VHICCardDetailInfo;
import gov.va.med.fw.service.ServiceException;

public class VHICCardInfoServiceImpl implements VHICCardInfoService{

    /**
     * 
     * @author DNS   zhangs
     * Date: September 2014
     *
     */
    private static final long serialVersionUID = -8408702241918806208L;
	private  VHICCardInfo vhicCardInfo = new VHICCardInfo();
	private String vpid = null;
	private PersonHelperService personHelperService= null;
		

	
	public VHICCardInfo getVhicCardInfo() {
		return vhicCardInfo;
	}

	public void setVhicCardInfo(VHICCardInfo vhicCardInfo) {
		this.vhicCardInfo = vhicCardInfo;
	}
	
	
	public VHICCardInfo getVHICCardStatusFromVHIC() throws ServiceException{
	//TODO VHIC to get VHIC Card Info from VHIC web service
	//Hard coded - temporary
		
	   vhicCardInfo.setTotalCardsMailed(3);
	   vhicCardInfo.setTotalCardsRequested(2);
	   vhicCardInfo.setCurrentVHICCardNumber("2323232323");
       vhicCardInfo.setCurrentVHICCardStatus("Hold");
       //Get VHIC Id from MVI via 1309 call
        String vhicId = getPersonHelperService().getVhicIdByVPID(vpid);
              
        //TODO VHIC  get VHIC Card Info Via VHIC web service when VHIC web service is ready
        //The following hard coded piece is for demo only before VHIC web service is ready
       
	   List<VHICCardDetailInfo> vhicCardDetailInfos = new ArrayList<VHICCardDetailInfo>();
	   try {
	  
		   	
		    VHICCardDetailInfo vhicCardDetailInfo = new VHICCardDetailInfo();
	   		vhicCardDetailInfo.setCardNumber("12121212");
	   	    String string = "January 8, 2015";
			Date date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
			vhicCardDetailInfo.setCardExpiredDate(date);
			string = "January 8, 2014";
			date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
			vhicCardDetailInfo.setStatusDate(date);
			vhicCardDetailInfo.setReason("Hold");
			vhicCardDetailInfo.setCardStatus("Submitted");
			vhicCardInfo.setCurrentVhicCardDetailInfo(vhicCardDetailInfo);
		
			
		    vhicCardDetailInfo = new VHICCardDetailInfo();
	   		vhicCardDetailInfo.setCardNumber("22222222");
	   	    string = "July 2, 2014";
			date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
			vhicCardDetailInfo.setCardExpiredDate(date);
			string = "July 2, 2013";
			date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
			vhicCardDetailInfo.setStatusDate(date);
			vhicCardDetailInfo.setReason("Hold");
			vhicCardDetailInfo.setCardStatus("Submitted");
			vhicCardDetailInfos.add(vhicCardDetailInfo);
			
			vhicCardDetailInfo = new VHICCardDetailInfo();
	   		vhicCardDetailInfo.setCardNumber("3333333");
	   	    string = "January 2, 2016";
			date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
			vhicCardDetailInfo.setCardExpiredDate(date);
			string = "June 2, 2014";
			date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
			vhicCardDetailInfo.setStatusDate(date);
			vhicCardDetailInfo.setReason("Hold");
			vhicCardDetailInfo.setCardStatus("Submitted");
			vhicCardDetailInfos.add(vhicCardDetailInfo);
			

            vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("4444444");
            string = "October 2, 2017";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "May 2, 2014";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Hold");
            vhicCardDetailInfo.setCardStatus("Submitted");
            vhicCardDetailInfos.add(vhicCardDetailInfo);
            

            vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("5555555");
            string = "December 2, 2013";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "July 3, 2010";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Cancelled");
            vhicCardDetailInfo.setCardStatus("Expired");
            vhicCardDetailInfos.add(vhicCardDetailInfo);
            
         // Comparator specific to VHICCardDetailInfo defined as in inner class
            
            Comparator comparator = new Comparator() {
                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = (pObject1 instanceof VHICCardDetailInfo) ? ((VHICCardDetailInfo)pObject1).getStatusDate() : null;
                    Date date2 = (pObject2 instanceof VHICCardDetailInfo) ? ((VHICCardDetailInfo)pObject2).getStatusDate() : null;
                    return (date1 != null && date2 != null) ? (-date1.compareTo(date2)) : 0;
                }
            };
         

            Collections.sort(vhicCardDetailInfos, comparator);

				
			vhicCardInfo.setVhicCardDetailInfoList(vhicCardDetailInfos);
	   
	   }
	         
   	  catch (Exception ex)
	 {
		throw new ServiceException("Error calling getVHICCardInfo", ex);
	} 
	   
	   return vhicCardInfo;
	}
	
	public void resetVhicCardInfo(String newVpid){
	    if(isVpidDifferent(newVpid)) {
    	    vhicCardInfo.setCurrentVHICCardNumber("No Data");
    	    vhicCardInfo.setCurrentVHICCardStatus("No Data");
    	    vhicCardInfo.setCurrentVhicCardDetailInfo(new VHICCardDetailInfo());
    	    vhicCardInfo.setVhicCardDetailInfoList(new ArrayList());
    	    vhicCardInfo.setTotalCardsRequested(0);
    	    vhicCardInfo.setTotalCardsMailed(0);
	    }
	    this.setVpid(newVpid);
	}
	
	
	public String getCurVhicCardID(){
		return vhicCardInfo.getCurrentVHICCardNumber();
	}
	
	public String getCurVhicCardStatus(){
		return vhicCardInfo.getCurrentVHICCardStatus();
	}

    public String getVpid() {
        return vpid;
    }

    public void setVpid(String vpid) {
        this.vpid = vpid;
    }
    
    public boolean isVpidDifferent(String newVpid){
        return (!newVpid.equals(this.vpid));
    }

    public PersonHelperService getPersonHelperService() {
        return personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    
       
}
