/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

// Java Classes

//Library classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.VAFacilityService;
import gov.va.med.fw.service.ServiceException;


/**
 * @author Martin Francisco
 */
public class VAFacilityServiceImpl extends AbstractRuleAwareServiceImpl implements VAFacilityService {

    public VAFacilityServiceImpl() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.VAFacilityService#findAll()
     */
    public VAFacility[] findAll() throws ServiceException {
        return (VAFacility[]) this.getLookupService().getAllVaFacilitys().toArray(new VAFacility[0]);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.VAFacilityService#findAllActive()
     */
    public VAFacility[] findAllActive() throws ServiceException {
        return (VAFacility[]) this.getLookupService().getAllVaFacilitys().toArray(new VAFacility[0]);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.VAFacilityService#getByStationNumber(java.lang.String)
     */
    public VAFacility getByStationNumber(String stationNumber)
            throws ServiceException {
        return this.getLookupService().getVaFacilityByStationNumber(stationNumber);
    }
}