/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.impl;

import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.person.exceptions.InvalidCriteriaException;
import gov.va.med.person.exceptions.NoRecordFoundException;
import gov.va.med.person.exceptions.PSException;
import gov.va.med.person.idmgmt.AuditResult;
import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.MatchCriteria;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.exceptions.ThresholdExceededException;
import gov.va.med.person.idmgmt.exceptions.VPIDException;
import gov.va.med.person.service.IPersonService;
import gov.va.med.person.service.IServiceStatus;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;



/**
 * Does nothing more than proxy actual PS CAIP calls.  Any post-processing of
 * data should NOT occur in this facade.
 * 
 * Created Apr 13, 2011 10:07:29 AM
 * @author Trinadh Kavuri
 */
public class PSSOADelegateServiceImpl implements
		IPersonService {

	private IPersonService psSOADelegate = null;
       
	
	
    public IPersonService getPsSOADelegate() {
		return psSOADelegate;
	}

	public void setPsSOADelegate(IPersonService psSOADelegate) {
		this.psSOADelegate = psSOADelegate;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#create(gov.va.med.person.idmgmt.IPersonIdentity)
	 */
	public IQualifiedIdentifier create(IPersonIdentity arg0)
			throws PSException {
		return getPsSOADelegate().create(arg0);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0)
			throws NoRecordFoundException, PSException, VPIDException {
		return getPsSOADelegate().obtain(arg0);

	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier, boolean)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0, boolean arg1)
			throws NoRecordFoundException, PSException,
			 VPIDException {
		return getPsSOADelegate().obtain(arg0, arg1);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.lang.String)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0, String arg1)
			throws NoRecordFoundException, PSException,VPIDException {
		return getPsSOADelegate().obtain(arg0, arg1);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.lang.String, boolean)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0, String arg1,
			boolean arg2) throws NoRecordFoundException, PSException,VPIDException {
		return getPsSOADelegate().obtain(arg0, arg1, arg2);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier[])
	 */
	public HashMap obtain(IQualifiedIdentifier[] arg0)
			throws PSException, ThresholdExceededException {
		return getPsSOADelegate().obtain(arg0);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IPersonIdentity, java.lang.String)
	 */
	public IPersonIdentity[] obtain(IPersonIdentity arg0, String arg1)
			throws PSException, ThresholdExceededException, InvalidCriteriaException {
		return getPsSOADelegate().obtain(arg0, arg1);		
	}

    public IPersonIdentity obtainCorrelation(IQualifiedIdentifier arg0)
        throws NoRecordFoundException, IllegalArgumentException, PSException
    {
        return getPsSOADelegate().obtainCorrelation(arg0);
    }

    public IPersonIdentity obtainCorrelation(IQualifiedIdentifier arg0, boolean arg1)
        throws NoRecordFoundException, IllegalArgumentException, PSException
    {
        return getPsSOADelegate().obtainCorrelation(arg0, arg1);
    }

    public HashMap obtainCorrelation(IQualifiedIdentifier[] arg0)
        throws NoRecordFoundException, IllegalArgumentException, PSException, ThresholdExceededException
    {
        return getPsSOADelegate().obtainCorrelation(arg0);
    }


    /* (non-Javadoc)
      * @see gov.va.med.person.delegate.ISignature#obtainHistory(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.sql.Date, java.sql.Date)
      */
    public IPersonIdentity[] obtainHistory(IQualifiedIdentifier arg0,
            Date arg1, Date arg2) throws PSException {
        return getPsSOADelegate().obtainHistory(arg0, arg1, arg2);
    }

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainHistory(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IPersonIdentity[] obtainHistory(IQualifiedIdentifier arg0)
			throws PSException {
		return getPsSOADelegate().obtainHistory(arg0);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainSOI(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IQualifiedIdentifier[] obtainSOI(IQualifiedIdentifier arg0)
			throws PSException {
		return getPsSOADelegate().obtainSOI(arg0);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainSOI(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.util.Collection)
	 */
	public IQualifiedIdentifier[] obtainSOI(IQualifiedIdentifier arg0,
			Collection arg1) throws PSException {
		return getPsSOADelegate().obtainSOI(arg0, arg1);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainVPID(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IQualifiedIdentifier obtainVPID(IQualifiedIdentifier arg0)
			throws PSException {
		return getPsSOADelegate().obtainVPID(arg0);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#update(gov.va.med.person.idmgmt.IPersonIdentity)
	 */
	public void update(IPersonIdentity arg0) throws PSException{
		getPsSOADelegate().update(arg0);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#notifyPsdOfAdrUpdate(java.lang.String)
	 */
	public void notifyPsdOfAdrUpdate(String arg0) throws PSException {
		getPsSOADelegate().notifyPsdOfAdrUpdate(arg0);
	}

    public AuditResult[] obtainAuditResults(IQualifiedIdentifier arg0)
        throws PSException {
        return getPsSOADelegate().obtainAuditResults(arg0);
    }


	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainVpidsBySsnVerificationStatus(gov.va.med.person.idmgmt.common.ISSN[])
	 */
	public IQualifiedIdentifier[] obtainVpidsBySsnVerificationStatus(ISSN[] arg0) throws PSException{
		return getPsSOADelegate().obtainVpidsBySsnVerificationStatus(arg0);
	}

    public IQualifiedIdentifier[] obtainVpidsBySsnVerificationStatus(ISSN[] arg0, String arg1)
        throws PSException{
        return getPsSOADelegate().obtainVpidsBySsnVerificationStatus(arg0, arg1);
    }

    /* (non-Javadoc)
      * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier[], java.lang.String)
      */
    public HashMap obtain(IQualifiedIdentifier[] arg0, String arg1) throws ThresholdExceededException {
        return getPsSOADelegate().obtain(arg0, arg1);
    }

    public IServiceStatus getStatus() throws PSException {        
        return getPsSOADelegate().getStatus();
    }

    public IPersonIdentity[] obtain(MatchCriteria arg0) throws InvalidCriteriaException, PSException, ThresholdExceededException {
        return getPsSOADelegate().obtain(arg0);
    }

    public AuditResult[] obtainAuditResults(IQualifiedIdentifier arg0, String arg1) throws PSException {
        return getPsSOADelegate().obtainAuditResults(arg0);
    }

    public int obtainCount(MatchCriteria arg0) throws InvalidCriteriaException, PSException {
        return getPsSOADelegate().obtainCount(arg0);
    }
    
    /*
     * Had to add when upgraded to PSIM 2.2.1.07
     */
    public String execute(String arg0) throws PSException {
        return getPsSOADelegate().execute(arg0);
    }
    
    /*
     * new PSIM APIs for VOA
     * 
     */
    public String changeIDState(final String request) throws PSException
    {
    	return getPsSOADelegate().execute(request);
    }
    
    public String addPreferredTreatingFacility(final String request) throws PSException
    {
    	return getPsSOADelegate().execute(request);
    }

	public IPersonIdentity[] obtainHistory(IQualifiedIdentifier iqualifiedidentifier, boolean flag) throws PSException, CaipInvocationException {
		// TODO Auto-generated method stub
		return null;
	}
    
    
}
