/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.person.exceptions.InvalidCriteriaException;
import gov.va.med.person.exceptions.NoRecordFoundException;
import gov.va.med.person.exceptions.PSException;
import gov.va.med.person.idmgmt.AuditResult;
import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
//import gov.va.med.person.idmgmt.request.IPSIMRequest;
//import gov.va.med.person.idmgmt.response.IPSIMResponse;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.MatchCriteria;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.exceptions.ThresholdExceededException;
import gov.va.med.person.idmgmt.exceptions.VPIDException;
import gov.va.med.person.service.IPersonService;
import gov.va.med.person.service.IServiceStatus;

//import gov.va.med.person.idmgmt.request.PSIMAddPrefTreatFacilityRequest;
//import gov.va.med.person.idmgmt.response.PSIMAddPrefTreatFacilityResponse;
//import gov.va.med.person.idmgmt.request.PSIMIDStateChangeRequest;
//
//import gov.va.med.person.idmgmt.request.PSIMRequestFactory;
//
//import gov.va.med.person.idmgmt.response.PSIMIDStateChangeResponse;


/**
 * Does nothing more than proxy actual PS CAIP calls.  Any post-processing of
 * data should NOT occur in this facade.
 * 
 * Created Apr 11, 2006 10:07:29 AM
 * @author DNS   BOHMEG
 */
public class PSCAIPDelegatedServiceImpl extends CAIPDelegatedService implements
		IPersonService {

       
    /* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#create(gov.va.med.person.idmgmt.IPersonIdentity)
	 */
	public IQualifiedIdentifier create(IPersonIdentity arg0)
			throws PSException, CaipInvocationException {
		return getPSDelegate().create(arg0);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0)
			throws NoRecordFoundException, PSException,
			CaipInvocationException, VPIDException {
		return getPSDelegate().obtain(arg0);

	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier, boolean)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0, boolean arg1)
			throws NoRecordFoundException, PSException,
			CaipInvocationException, VPIDException {
		return getPSDelegate().obtain(arg0, arg1);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.lang.String)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0, String arg1)
			throws NoRecordFoundException, PSException,
			CaipInvocationException, VPIDException {
		return getPSDelegate().obtain(arg0, arg1);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.lang.String, boolean)
	 */
	public IPersonIdentity obtain(IQualifiedIdentifier arg0, String arg1,
			boolean arg2) throws NoRecordFoundException, PSException,
			CaipInvocationException, VPIDException {
		return getPSDelegate().obtain(arg0, arg1, arg2);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier[])
	 */
	public HashMap obtain(IQualifiedIdentifier[] arg0)
			throws PSException, ThresholdExceededException, CaipInvocationException {
		return getPSDelegate().obtain(arg0);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IPersonIdentity, java.lang.String)
	 */
	public IPersonIdentity[] obtain(IPersonIdentity arg0, String arg1)
			throws PSException, ThresholdExceededException,
			CaipInvocationException, InvalidCriteriaException {
		return getPSDelegate().obtain(arg0, arg1);		
	}

    public IPersonIdentity obtainCorrelation(IQualifiedIdentifier arg0)
        throws NoRecordFoundException, IllegalArgumentException, PSException
    {
        return getPSDelegate().obtainCorrelation(arg0);
    }

    public IPersonIdentity obtainCorrelation(IQualifiedIdentifier arg0, boolean arg1)
        throws NoRecordFoundException, IllegalArgumentException, PSException
    {
        return getPSDelegate().obtainCorrelation(arg0, arg1);
    }

    public HashMap obtainCorrelation(IQualifiedIdentifier[] arg0)
        throws NoRecordFoundException, IllegalArgumentException, PSException, ThresholdExceededException
    {
        return getPSDelegate().obtainCorrelation(arg0);
    }


    /* (non-Javadoc)
      * @see gov.va.med.person.delegate.ISignature#obtainHistory(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.sql.Date, java.sql.Date)
      */
    public IPersonIdentity[] obtainHistory(IQualifiedIdentifier arg0,
            Date arg1, Date arg2) throws PSException, CaipInvocationException {
        return getPSDelegate().obtainHistory(arg0, arg1, arg2);
    }

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainHistory(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IPersonIdentity[] obtainHistory(IQualifiedIdentifier arg0)
			throws PSException, CaipInvocationException {
		return getPSDelegate().obtainHistory(arg0);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainSOI(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IQualifiedIdentifier[] obtainSOI(IQualifiedIdentifier arg0)
			throws PSException, CaipInvocationException {
		return getPSDelegate().obtainSOI(arg0);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainSOI(gov.va.med.person.idmgmt.IQualifiedIdentifier, java.util.Collection)
	 */
	public IQualifiedIdentifier[] obtainSOI(IQualifiedIdentifier arg0,
			Collection arg1) throws PSException, CaipInvocationException {
		return getPSDelegate().obtainSOI(arg0, arg1);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainVPID(gov.va.med.person.idmgmt.IQualifiedIdentifier)
	 */
	public IQualifiedIdentifier obtainVPID(IQualifiedIdentifier arg0)
			throws PSException, CaipInvocationException {
		return getPSDelegate().obtainVPID(arg0);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#update(gov.va.med.person.idmgmt.IPersonIdentity)
	 */
	public void update(IPersonIdentity arg0) throws PSException,
			CaipInvocationException {
		getPSDelegate().update(arg0);		
	}

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#notifyPsdOfAdrUpdate(java.lang.String)
	 */
	public void notifyPsdOfAdrUpdate(String arg0) throws PSException,
			CaipInvocationException {
		getPSDelegate().notifyPsdOfAdrUpdate(arg0);
	}

    public AuditResult[] obtainAuditResults(IQualifiedIdentifier arg0)
        throws PSException, CaipInvocationException
    {
        return getPSDelegate().obtainAuditResults(arg0);
    }

    private IPersonService getPSDelegate() throws CaipInvocationException {
        return (IPersonService) getCAIPDelegate();
    }

	/* (non-Javadoc)
	 * @see gov.va.med.person.delegate.ISignature#obtainVpidsBySsnVerificationStatus(gov.va.med.person.idmgmt.common.ISSN[])
	 */
	public IQualifiedIdentifier[] obtainVpidsBySsnVerificationStatus(ISSN[] arg0) throws PSException, CaipInvocationException {
		return getPSDelegate().obtainVpidsBySsnVerificationStatus(arg0);
	}

    public IQualifiedIdentifier[] obtainVpidsBySsnVerificationStatus(ISSN[] arg0, String arg1)
        throws PSException, CaipInvocationException
    {
        return getPSDelegate().obtainVpidsBySsnVerificationStatus(arg0, arg1);
    }

    /* (non-Javadoc)
      * @see gov.va.med.person.delegate.ISignature#obtain(gov.va.med.person.idmgmt.IQualifiedIdentifier[], java.lang.String)
      */
    public HashMap obtain(IQualifiedIdentifier[] arg0, String arg1) throws ThresholdExceededException, CaipInvocationException {
        return getPSDelegate().obtain(arg0, arg1);
    }

    public IServiceStatus getStatus() throws PSException, CaipInvocationException {        
        return getPSDelegate().getStatus();
    }

    public IPersonIdentity[] obtain(MatchCriteria arg0) throws InvalidCriteriaException, PSException, ThresholdExceededException, CaipInvocationException {
        return getPSDelegate().obtain(arg0);
    }

    public AuditResult[] obtainAuditResults(IQualifiedIdentifier arg0, String arg1) throws PSException, CaipInvocationException {
        return getPSDelegate().obtainAuditResults(arg0);
    }

    public int obtainCount(MatchCriteria arg0) throws InvalidCriteriaException, PSException, CaipInvocationException {
        return getPSDelegate().obtainCount(arg0);
    }
    
    /*
     * Had to add when upgraded to PSIM 2.2.1.07
     */
    public String execute(String arg0) throws PSException, CaipInvocationException {
        return getPSDelegate().execute(arg0);
    }
    
    /*
     * new PSIM APIs for VOA
     * 
     */
    public String changeIDState(final String request) throws PSException
    {
    	return getPSDelegate().execute(request);
    }
    
    public String addPreferredTreatingFacility(final String request) throws PSException
    {
    	return getPSDelegate().execute(request);
    }

	public IPersonIdentity[] obtainHistory(IQualifiedIdentifier iqualifiedidentifier, boolean flag) throws PSException, CaipInvocationException {
		// TODO Auto-generated method stub
		return null;
	}
    
    
}
