package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.MilitaryInfoProcessor;
import gov.va.med.esr.service.MilitaryInfoService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.esr.service.trigger.ProcessTriggerEvent;
import gov.va.med.fw.util.InvalidConfigurationException;
import gov.va.med.fw.security.SecurityContextHelper;
/**
 * Process miscellaneous Military Service events
 *
 * @author DNS   ruizc
 *
 */
public class MilitaryInfoProcessorImpl extends AbstractComponent implements MilitaryInfoProcessor {

	/**
	 *
	 */
	private static final long serialVersionUID = -4721117129644782023L;

	public static final String HEC_RECORD_CREATE_AUDIT_ID = "HecRecordProcess";
	private PersonService personService = null;
	private MilitaryInfoService militaryService = null;

	public void processHecRecordTrigger(TriggerEvent triggerEvent) throws ServiceException {
		ProcessTriggerEvent event = (ProcessTriggerEvent)triggerEvent;
		SecurityContextHelper.getSecurityContext().setLogicalName(HEC_RECORD_CREATE_AUDIT_ID);
		Person person = getPerson(event);
		getMilitaryService().processSeeding(person);
		getMilitaryService().processMSDSLogicForCLV(person);
	}
	private Person getPerson(ProcessTriggerEvent triggerEvent) throws ServiceException {
		try {
			Person person = null;
			PersonEntityKey key = triggerEvent.getPersonId();
			if (key != null)
				person = getPersonService().getPerson(key);

			return person;
		}
		catch (ServiceException e) {
			throw new ServiceException(
					"Error retrieving a person from the ProcessTriggerEvent", e);
		}
	}
	/**
	 * Verify that the required properties are set.
	 */
	public void afterPropertiesSet() {
		if (personService == null) {
			throw new InvalidConfigurationException(
					"personService must be set on " + getClass().getName());
		}
		if (militaryService == null) {
			throw new InvalidConfigurationException(
					"militaryInfoService must be set on "
					+ getClass().getName());
		}
	}
	public PersonService getPersonService() {
		return personService;
	}
	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}
	public MilitaryInfoService getMilitaryService() {
		return militaryService;
	}
	public void setMilitaryService(MilitaryInfoService militaryService) {
		this.militaryService = militaryService;
	}
}
