/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

import java.util.Map;

import gov.va.med.fw.security.LDAPServiceImpl;
import gov.va.med.fw.security.UserPrincipal;

import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;

public class LDAPUserInfoServiceImpl extends LDAPServiceImpl {
    public static String DISABLED_USERS = "OU=Disabled Users";
    public static String DISABLED_ACCOUNTS = "OU=Disabled Accounts";
    //??public static String DISABLED_PARTNERS = "Disabled Partners";
    public static String [] DISABLED_GROUPS = {DISABLED_USERS, DISABLED_ACCOUNTS};
    public LDAPUserInfoServiceImpl() {
        super();
    }
    /**
     * username is not stored in LDAP in standard format
     * some users have email id and some id@domain format
     * sAMAccountName is the only standard id found in ldap which is
     * equal to the vha network id 
     */
    protected UserPrincipal buildUserPrincipal(Map properties) {
        
        String dn = (String) properties.get(LDAP_DISTINGUISHED_NAME);
        for (int i=0; i<DISABLED_GROUPS.length; i++){
            if (dn.indexOf(DISABLED_GROUPS[i]) > -1){
                //The user is a part of Disabled group
                return null;
            }
        }
        String userName = (String) properties.get(LDAP_ATTR_USER_ACCOUNT_NAME);        
        ESRUserPrincipalImpl user = new ESRUserPrincipalImpl(userName); 
        user.setFamilyName((String) properties.get(LDAP_ATTR_USER_LAST_NAME));
        user.setGivenName((String) properties.get(LDAP_ATTR_USER_FIRST_NAME));
        user.setMiddleName((String) properties.get(LDAP_ATTR_USER_MIDDLE_INITIALS));
        user.setJobTitle((String) properties.get(LDAP_ATTR_USER_JOB_TITLE));
        return user;
    }    
}
