package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.IdmServiceVO;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

public interface IdmWebServiceDelegate extends Serializable{

	public List getCorrelationsByVPID(VPIDEntityKey key)
	throws ServiceException;
	
	

	/**
	 * get the correlations with a Fully Qualified Identifier: "id^type^station number^assigning authority"
	 * e.g. "1008590379V913421^NI^200M^USVHA", "0000001008590379V913421000000^PI^200ESR^USVHA", 
	 *   	"1606118356^NI^200DOD^USDOD", "186317^PI^556^USVHA"
	 * @param fullyQualifiedId
	 * @return List of correlations in PatientIdentifier objects
	 * @throws ServiceException
	 */
	public List getCorrelationsByFullyQualifiedIdentifier(String fullyQualifiedId) throws ServiceException;

	
	public Set search(PersonIdentityTraits traits, boolean attendedSearch) throws ServiceException;
	
	public PersonIdentityTraits search(FullyQualifiedIdentity id, boolean attendedSearch) throws ServiceException;
	

	public VPIDEntityKey addPerson(IdmServiceVO idmServiceVO, IdMSearchInfo searchInfo )throws ServiceException;
	
	public void updatePerson(IdmServiceVO idmServiceVO) throws ServiceException;
	
	public VPIDEntityKey addCorrelation(IdmServiceVO idmServiceVO) throws ServiceException;
	
	public FullyQualifiedIdentity addPreferredFacility(IdmServiceVO idmServiceVO) throws ServiceException;
	
	public PersonIdentityTraits getESRCorrelation(VPIDEntityKey vpid) throws ServiceException;
	
	/**
	 * given person traits, search with composite call 
	 * @param traits
	 * @return
	 * @throws ServiceException
	 */
	public Set searchWithCompositeCall(PersonIdentityTraits traits, IdMSearchInfo searchInfo) throws ServiceException;
	
	
	
	//CCR11776- if a search is performed by a dfn that is deprecated, the implementation sets the pv traits
	//to be deprecated for preventing messages to be sent for this deprecated dfn
	
	/**
	 * search with a fully qualified identity to request a composite service call
	 * @param id
	 * @return PersonIdentityTraits
	 * @throws ServiceException
	 */
	 public PersonIdentityTraits searchWithCompositeCall(FullyQualifiedIdentity id, boolean isSearchByDfn, IdMSearchInfo searchInfo) throws ServiceException;

}
