/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

// Java classes

// Library classes

// Framework classes
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractVersionedEntity;

// EDB classes

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public class HistoricalInfo extends AbstractEntity {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3870235292004407539L;
	private ChangeEvent event = null;
   private AbstractVersionedEntity entity = null;
   
   /**
    * @param event
    * @param entity
    */
   public HistoricalInfo(ChangeEvent event, AbstractVersionedEntity entity) {
      super();
      this.event = event;
      this.entity = entity;
   }

   /**
    * @return Returns the entity.
    */
   public AbstractVersionedEntity getEntity() {
      return this.entity;
   }
   
   /**
    * @return Returns the event.
    */
   public ChangeEvent getEvent() {
      return this.event;
   }
   
   /**
    * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   protected void buildToString(ToStringBuilder builder) {
      // FIXME Auto-generated method stub
      builder.append( "Change event", event );
      builder.append( "Entity", entity );
   }
   
   /** Convenience method to get the current (relative to ChangeEvent) version */
   public AbstractVersionedEntity getCurrentVersion() {
	   return entity;
   }
   
   /** Convenience method to get the previous (relative to getCurrentVersion) version */
   public AbstractVersionedEntity getPreviousVersion() {
	   return entity.getPreviousVersion();
   }   
}