/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.hbp.HealthBenefitPlanName;
import gov.va.med.esr.common.persistent.hbp.HBPDefinitionDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.HBPDefinitionService;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class HBPDefinitionServiceImpl extends AbstractRuleAwareServiceImpl implements HBPDefinitionService
{
	private Map<String, HistoryDAO> historyDAOs;
	private HBPDefinitionDAO hbpDefinitionDAO;
	private HistoryDAO hbpNamesFullHistoryDAO;

    public HBPDefinitionServiceImpl() {
        super();
    }
    
    public Map<String, HistoryDAO> getHistoryDAOs() {
        return historyDAOs;
    }

    public void setHistoryDAOs(Map<String, HistoryDAO> historyDAOs) {
        this.historyDAOs = historyDAOs;
    }
	    
	public HBPDefinitionDAO getHbpDefinitionDAO() {
		return hbpDefinitionDAO;
	}

	public void setHbpDefinitionDAO(HBPDefinitionDAO hbpDefinitionDAO) {
		this.hbpDefinitionDAO = hbpDefinitionDAO;
	}

	public HistoryDAO getHbpNamesFullHistoryDAO() {
		return hbpNamesFullHistoryDAO;
	}

	public void setHbpNamesFullHistoryDAO(HistoryDAO hbpNamesFullHistoryDAO) {
		this.hbpNamesFullHistoryDAO = hbpNamesFullHistoryDAO;
	}

	
    /* __JC_TODO__
     public ESRUserPrincipalImpl updateUserProfile(ESRUserPrincipalImpl user)
     
            throws ServiceException {
        //set all the required values and update
        try
        {
            // Ensure that something changed for the "update" case.
            if (user.getEntityKey() != null)
            {
                // Get the onFile user
                ESRUserPrincipalImpl onFileUser = (ESRUserPrincipalImpl)getUserById(user.getEntityKey());

                // Ensure that something changed on the incoming entity as compared to the onFile entity
                ensureEntityChanged(user, onFileUser);

                // Evict the on-file entity since we aren't overlaying data onto it
                getSecurityDAO().evict(onFileUser);
            }

            //update user account
            getSecurityDAO().update(user);
        }catch (DAOException ex) {
            throw new ServiceException("User Account Update Failed for user" + 
                    user.getName(),ex);
        }
        return user;
    }

    public ESRUserPrincipalImpl updateUserAccount(ESRUserPrincipalImpl user)
        throws ServiceException {
        //set all the required values and update
        try
        {
            // Ensure that something changed for the "update" case.
            if (user.getEntityKey() != null)
            {
                // Get the onFile user
                ESRUserPrincipalImpl onFileUser = (ESRUserPrincipalImpl)getUserById(user.getEntityKey());
        
                // Ensure that something changed on the incoming entity as compared to the onFile entity
                ensureEntityChanged(user, onFileUser);
        
                // merge user account information and update
                getMergeRuleService().mergeUserAccount(user, onFileUser);
                getSecurityDAO().update(onFileUser);
            }
            else {        
                //update user account
                getSecurityDAO().update(user);
            }
        }catch (DAOException ex) {
            throw new ServiceException("User Account Update Failed for user" + 
                    user.getName(),ex);
        }
        return user;
    }    
    
 
    
  
    
    /**
     * Search for user profile based on the user demographic information
     */
  /*  public ESRUserPrincipalImpl findUser(UserPrincipal user) 
        throws ServiceException {
        Validate.notNull(user, "UserPrincipal can not be NULL.");
        try {
            return (ESRUserPrincipalImpl) getSecurityDAO().findUser(user);
        } catch(DAOException ex) {
            throw new ServiceException("Error while searching the user prpfile Reason: ", ex);                    
        }
    }

    public CapabilitySet getCapabilitySetById(EntityKey entityKey) throws ServiceException {
        return (CapabilitySet)getEntityByEntityKey(entityKey);
    }

    public CapabilitySet getCapabilitySetByName(String name) throws ServiceException {
        try {
            return getSecurityDAO().findCapabilitySetByName(name);
        }catch(DAOException ex) {
            throw new ServiceException("Error while searching for CapabilitySet ", ex);                    
        }
    }
    
    public RolePrincipal getRoleById(EntityKey entityKey) throws ServiceException {        
        return (RolePrincipal)getEntityByEntityKey(entityKey);
    }*/

    /**
     * Get ChangeTimes for the entity
     * @param entityKey
     * @return
     * @throws ServiceException
     */
    public Set getHistoryChangeTimes(EntityKey entityKey)
    throws ServiceException {
        try 
        {
            HistoryDAO historyDAO = getHistoryDAO(entityKey.getEntityClass().getName());
            return historyDAO.getHistoryChangeTimes(entityKey);
        } catch (DAOException e) {
                throw new ServiceException(e.getMessage(), e);
        }
    }

    /**
    * Get current and previous address by change time
    * 
    * @param event
    * @return
    * @throws ServiceException
    */
    public HistoricalInfo getHistoryByChangeTime(ChangeEvent event)
        throws ServiceException {
        try {
            HistoryDAO historyDAO = getHistoryDAO(event.getEntityKey().getEntityClass().getName());
            return historyDAO.getHistoryByChangeTime(event);
        } catch (DAOException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }
    
/*
    private Object getEntityByEntityKey(EntityKey entityKey) throws ServiceException {
        Validate.notNull(entityKey.getKeyValue(),"Entity Key Value can not be NULL");
        Validate.notNull(entityKey.getEntityClass(),"Entity Class can not be NULL");        
        try{            
            return getSecurityDAO().getByKey(entityKey);
        }catch(DAOException ex) {
            throw new ServiceException("Error while retrieving entity of type: " + entityKey.getEntityClass().getName(), ex);                                
        }
    }
  */  
  
    private HistoryDAO getHistoryDAO(String entityClassName) {
        return (HistoryDAO) getHistoryDAOs().get(entityClassName);
    }


	@Override
	public Set getFullHistoryChangeTimes(EntityKey entityKey)
			throws ServiceException {
        try
        {
            return hbpNamesFullHistoryDAO.getHistoryChangeTimes(entityKey);
        }
        catch (DAOException e)
        {
            throw new ServiceException(e.getMessage(), e);
        }
	}

	@Override
	public HistoricalInfo getFullHistoryByChangeTime(ChangeEvent event)
			throws ServiceException {
        try
        {
            return hbpNamesFullHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e)
        {
            throw new ServiceException(e.getMessage(), e);
        }
	}


	@Override
	public HealthBenefitPlanName addHealthBenefitPlanName(
			HealthBenefitPlanName incoming) throws ServiceException {
		return updateHealthBenefitPlanName(incoming);
	}

	@Override
	public HealthBenefitPlanName updateHealthBenefitPlanName(
			HealthBenefitPlanName incoming) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    /**
     * Get all the HealthBenefitPlanNames from the Database
     */    

	public List<HealthBenefitPlanName> getAllHealthBenefitPlanNames() 
	 throws ServiceException {
		try {
			return hbpDefinitionDAO.findAllHealthBenefitPlanNames();
		}        
		catch (DAOException daoe) {
            throw new ServiceException(" Could not retrive HealthBenefitPlanNames ", daoe);
        }

	}

	@Override
	public HealthBenefitPlanName getHealthBenefitPlanNameByID(
			EntityKey entityKey) 	 
	throws ServiceException {
		try {
			return hbpDefinitionDAO.getHealthBenefitPlanNameById(entityKey);
		}        
		catch (DAOException daoe) {
            throw new ServiceException(" Could not retrive HealthBenefitPlanName ", daoe);
        }
	}
	
 
}
