/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.service.impl;

// Java classes
import gov.va.med.fw.model.EntityKey;

import java.sql.Timestamp;

import org.apache.commons.lang.builder.ToStringBuilder;

// EDB classes

/**
 * Project: Common
 * 
 * @author DNS   CHENJ2
 * @version 1.0
 */
public class FinancialsChangeEvent extends ChangeEvent {

	private static final long serialVersionUID = 7075069476202739147L;

	private Integer incomeYear = null;

	public FinancialsChangeEvent() {
		super();
	}

	public FinancialsChangeEvent(Timestamp timeStamp, EntityKey entityKey,
			Integer incomeYear) {
		super(timeStamp, entityKey);
		this.incomeYear = incomeYear;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("income year", incomeYear);
	}

	public Integer getIncomeYear() {
		return incomeYear;
	}

	public void setIncomeYear(Integer incomeYear) {
		this.incomeYear = incomeYear;
	}
}
