/**
 * 
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.service.CompletedReportService;
import gov.va.med.esr.service.CompletedReportsSearchQueryInfo;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author DNS   CHENJ2
 *
 */
public class CompletedReportServiceImpl extends StandardReportServiceImpl
		implements CompletedReportService {

	
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/*
	 * Search completed reports using filter parameters provided 
	 * 
	 * @param searchQueryInfo
	 * @return
	 * @throws ServiceException
	 */
	public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
		
		List rptItems=new ArrayList();
		try {
			CompletedReportsSearchQueryInfo searchCriteria = (CompletedReportsSearchQueryInfo) searchQueryInfo;			
			List allReports = getReportDAO().searchCompletedReports(searchCriteria);
			if (allReports != null) {
	            for (Iterator iter = allReports.iterator(); iter.hasNext();) {
	            	SimpleCompletedReport completedReport = (SimpleCompletedReport) iter.next();
	            	
		                if (this.isUserPermittedToScheduleRunDeleteArchive(searchCriteria.getUser(), completedReport.getStandardReport())||
		                	this.isUserPermittedToView(searchCriteria.getUser(), completedReport.getStandardReport())) {
		                	rptItems.add(completedReport);
		                }
	            	
	            }
	        }
		} catch (DAOException e) {
			throw new ServiceException("CompletedReports Search Failed.  searchQueryInfo = " + searchQueryInfo, e);
		}
        // Set the total entries to actual value to display pagination info correctly.
        searchQueryInfo.setTotalNumberOfEntries(rptItems.size());
		return rptItems;
	}    
    
}
