/*
 * Created on May 31, 2005 TODO To change the template for this generated file
 * go to Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.comms.CommsBulletin;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.comms.CommsEmailBulletinDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.EnvironmentParamService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.esr.service.trigger.BulletinTrigger.DataType;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.person.idmgmt.VPID;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.mail.SimpleMailMessage;

/**
 * History: Added logging info <br>
 * Project: Comms</br> 
 * Created on: 11:54:21 AM </br>
 * 
 * @author: ESR Team
 */
public class CommsEmailBulletinServiceImpl extends AbstractComponent implements
        CommsEmailBulletinService {

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 7123593184875571623L;
    public static final String TAG_VPID = "VPID";

    private static Hashtable bulletinTable = new Hashtable();

    private MailService mailService;

    private SimpleMailMessage message;

    private CommsEmailBulletinDAO dao = null;
    
    private PSDelegateService psDelegateService = null;
    
    private LookupService lookupService = null;
    
    private EnvironmentParamService environmentParamService;
    
    public CommsEmailBulletinServiceImpl(CommsEmailBulletinDAO emailDAO) {
        super();
        if (emailDAO == null)
            throw new IllegalArgumentException(
                    "CommsEmailBulletinDAO is required as a parameter for constructor");

        dao = emailDAO;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();

        Validate.notNull(this.dao,
                "A dao of type CommsEmailBulletinDAO must be configured");
        Validate.notNull(message, "mesage is required");
        Validate.notNull(mailService, "mailService is required");
        Validate.notNull(psDelegateService, "psDelegateService is required");
        Validate.notNull(lookupService, "lookupService is required");
    }

    public SimpleMailMessage getMessage() {
        return message;
    }

    public void setMessage(SimpleMailMessage message) {
        this.message = message;
    }

    public void sendEmailBulletin( BulletinTrigger.DataType bullName,
                                             Map dataMap, Person person) throws ServiceException {

        Validate.notNull( bullName, "A bulletin must not be null" );
        Validate.notNull( bullName.getName(), "A bulletin name must not be null" );

        if( this.logger.isDebugEnabled() ) {
            this.logger.debug( "Send email bulletin: " + bullName.getName() );
        }

        String bulletinName = bullName.getName();

        CommsBulletin bulletin = getEmailBulletin(bulletinName);

        Hashtable parameterValues = new Hashtable(dataMap);
        if (bulletin != null) {
        	
        	Set personSites = person == null ? new HashSet() : getSites(person.getVPIDEntityKey());
        	Map siteIdentityMap = getSiteIdentityMap(personSites);
        	
        	if (BulletinTrigger.DataType.HEC_NOTIFY_SITE_VETERAN_VERIFICATION.getName().equals(bulletin.getCommsBulletinName())) {
        		String vistedSiteNames = getVisitedSitenames(personSites);
        		parameterValues.put(BulletinTriggerEvent.HecNotifySiteVeteranVerification.SITES_VETERAN_VISITED,
                           	vistedSiteNames);
        	}
        	
        	String recipientList = null;
        	
        	// Merge the static email list and dynamic email list
            //String siteRecipientList = 
            Map facilityEmailAddressMap = constructSiteRecipientList(bulletin, dataMap, person, personSites);

            //Get the recipientList from template
            if(StringUtils.isNotBlank(bulletin.getRecipient())) {
            	recipientList = replaceParameters(bulletin.getRecipient(),parameterValues);
            }
                        
            // store the bulletin in the cache
            bulletinTable.put(bulletinName, bulletin);

            //Mails are being sent only to recipient list 
        	if(recipientList != null && facilityEmailAddressMap.size() == 0) {
	            
	            String[] toList = recipientList.split(",");
	            
	            String subject = replaceParameters(bulletin.getSubject(),parameterValues);
	            
	            String bodyText = generateEmailText(bulletin.getCommsBulletinText(),
	            		parameterValues, person, null);
                
                if(logger.isInfoEnabled())
                    logger.info("Sending Bulletin " + bulletin.getCommsBulletinName());   
	
	            this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
        		if(logger.isInfoEnabled())
        			logger.info("Bulletin " + bulletin.getCommsBulletinName() + " sent");

        	} 
        	else if (facilityEmailAddressMap.size() > 0){
        		//Send individual e-mails to each site with dfn and site number
        		Set facilities = facilityEmailAddressMap.keySet();
        		for (Iterator iter=facilities.iterator(); iter.hasNext();){
        			VAFacility facility = (VAFacility)iter.next();
        			String emailAddressList = (String)facilityEmailAddressMap.get(facility);
        			if (recipientList != null) {
        				emailAddressList = emailAddressList + "," + recipientList;
        			}
        			
        			//sene email to site and recipient list
    	            String[] toList = emailAddressList.split(",");
    	            
    	            String subject = replaceParameters(bulletin.getSubject(),parameterValues);
    	            
    	            String bodyText = generateEmailText(bulletin.getCommsBulletinText(),
    	            		parameterValues, person, (SiteIdentity)siteIdentityMap.get(facility));
                    
                    if(logger.isInfoEnabled())
                        logger.info("Sending Bulletin " + bulletin.getCommsBulletinName());   
    	
    	            this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
    	            
            		if(logger.isInfoEnabled())
            			logger.info("Bulletin " + bulletin.getCommsBulletinName() + " sent");    	            
        		}
        	}        		
        	else {
        		if(logger.isInfoEnabled())
        			logger.info("Bulletin " + bulletin.getCommsBulletinName() + " is NOT configured with any recipients....ignoring");
        	}
        }
        else
        {
            ServiceException ex = new ServiceException("Email Bulletin with name: " + bulletinName
                    + " does not exist");
            logger.error("ERROR email bulletin does not exist while sending an email bulletin", ex);
            throw ex;
        }

    }

    // CodeCR12798 ESE VOA BizFlow - add email notification to BizFlow regarding Person Not Found for Veteran Submitted
    public void sendVOAWorkflowEmailBulletin(BulletinTrigger.DataType bullName,
            Map dataMap, Person person, String formType) throws ServiceException {

        Validate.notNull( bullName, "A bulletin must not be null" );
        Validate.notNull( bullName.getName(), "A bulletin name must not be null" );

        if( this.logger.isDebugEnabled() ) {
            this.logger.debug( "Send email bulletin: " + bullName.getName() );
        }

        String bulletinName = bullName.getName();

        CommsBulletin bulletin = getEmailBulletin(bulletinName);

        Hashtable parameterValues = new Hashtable(dataMap);
        if (bulletin != null) {
        	
        	Set personSites = person == null ? new HashSet() : getSites(person.getVPIDEntityKey());
        	Map siteIdentityMap = getSiteIdentityMap(personSites);
        	
        	if (BulletinTrigger.DataType.HEC_NOTIFY_SITE_VETERAN_VERIFICATION.getName().equals(bulletin.getCommsBulletinName())) {
        		String vistedSiteNames = getVisitedSitenames(personSites);
        		parameterValues.put(BulletinTriggerEvent.HecNotifySiteVeteranVerification.SITES_VETERAN_VISITED,
                           	vistedSiteNames);
        	}
        	
        	String recipientList = null;
        	
        	// Merge the static email list and dynamic email list
            //String siteRecipientList = 
            Map facilityEmailAddressMap = constructSiteRecipientList(bulletin, dataMap, person, personSites);

            //Get the recipientList from template
            if(StringUtils.isNotBlank(bulletin.getRecipient())) {
            	recipientList = replaceParameters(bulletin.getRecipient(),parameterValues);
            }
                        
            // store the bulletin in the cache
            bulletinTable.put(bulletinName, bulletin);

            //Mails are being sent only to recipient list 
        	if(recipientList != null && facilityEmailAddressMap.size() == 0) {
	            
	            String[] toList = recipientList.split(",");
	            
	            String subject = null;

	            subject = replaceParameters(bulletin.getSubject(),parameterValues) + " - " + formType;           	

	            /*String bulletinText = replaceParameters(bulletin.getCommsBulletinText(),parameterValues) + "\nVeteran logon ID submitted: ~FULLY_QUALIFIED_ID~" +
	            "\nVeteran logon identifier type: ~Name~" +
	            "\nVOA Form Submission ID: ~VOA_ENROLLMENT_APP_ID~";
	           
					 String bodyText = generateEmailText(bulletinText,
					 parameterValues, person, null);*/

				String bodyText = generateEmailText(bulletin.getCommsBulletinText(),
	            	parameterValues, person, null);
                
                if(logger.isInfoEnabled())
                    logger.info("Sending Bulletin " + bulletin.getCommsBulletinName());   
	
	            this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
        		if(logger.isInfoEnabled())
        			logger.info("Bulletin " + bulletin.getCommsBulletinName() + " sent");

        	} 
        	else if (facilityEmailAddressMap.size() > 0){
        		//Send individual e-mails to each site with dfn and site number
        		Set facilities = facilityEmailAddressMap.keySet();
        		for (Iterator iter=facilities.iterator(); iter.hasNext();){
        			VAFacility facility = (VAFacility)iter.next();
        			String emailAddressList = (String)facilityEmailAddressMap.get(facility);
        			if (recipientList != null) {
        				emailAddressList = emailAddressList + "," + recipientList;
        			}
        			
        			//sene email to site and recipient list
    	            String[] toList = emailAddressList.split(",");
    	            
    	            String subject = replaceParameters(bulletin.getSubject(),parameterValues);
    	            
    	            String bodyText = generateEmailText(bulletin.getCommsBulletinText(),
    	            		parameterValues, person, (SiteIdentity)siteIdentityMap.get(facility));
                    
                    if(logger.isInfoEnabled())
                        logger.info("Sending Bulletin " + bulletin.getCommsBulletinName());   
    	
    	            this.sendSimpleMailMessage(null, toList, null, subject, bodyText);
    	            
            		if(logger.isInfoEnabled())
            			logger.info("Bulletin " + bulletin.getCommsBulletinName() + " sent");    	            
        		}
        	}        		
        	else {
        		if(logger.isInfoEnabled())
        			logger.info("Bulletin " + bulletin.getCommsBulletinName() + " is NOT configured with any recipients....ignoring");
        	}
        }
        else
        {
            ServiceException ex = new ServiceException("Email Bulletin with name: " + bulletinName
                    + " does not exist");
            logger.error("ERROR email bulletin does not exist while sending an email bulletin", ex);
            throw ex;
        }

    }

    
    
    public void sendEmailBulletinTo(BulletinTrigger.DataType bullName,
			Map dataMap, String[] toList) throws ServiceException {

		Validate.notNull(bullName, "A bulletin must not be null");
		Validate.notNull(bullName.getName(), "A bulletin name must not be null");
		Validate.notEmpty(toList, "A bulletin To Email Addresses must not be empty");

		if (this.logger.isDebugEnabled()) {
			this.logger.debug("Send email bulletin: " + bullName.getName());
		}

		String bulletinName = bullName.getName();

		CommsBulletin bulletin = getEmailBulletin(bulletinName);

		Hashtable parameterValues = new Hashtable(dataMap);
		if (bulletin != null) 
		{
				String subject = replaceParameters(bulletin.getSubject(),
						parameterValues);

				String bodyText = generateEmailText(bulletin
						.getCommsBulletinText(), parameterValues, null, null);

				if (logger.isInfoEnabled())
					logger.info("Sending Bulletin "
							+ bulletin.getCommsBulletinName());

				this.sendSimpleMailMessage(null, toList, null, subject,
						bodyText);
				if (logger.isInfoEnabled())
					logger.info("Bulletin " + bulletin.getCommsBulletinName()
							+ " sent");


		} else {
			ServiceException ex = new ServiceException(
					"Email Bulletin with name: " + bulletinName
							+ " does not exist");
			logger
					.error(
							"ERROR email bulletin does not exist while sending an email bulletin",
							ex);
			throw ex;
		}

	}
    
    /**
     * Send emailBulletin to specified email addresses.
     */
    @Override
	public void sendEmailBulletin(DataType bulletinType, String emailAddress)
			throws ServiceException {
		Validate.notNull(bulletinType, "A bulletin must not be null");
		Validate.notNull(bulletinType.getName(),
				"A bulletin name must not be null");
		Validate.notNull(emailAddress, "emailAddress must not be null");

		if (this.logger.isDebugEnabled()) {
			this.logger.debug("Send email bulletin: " + bulletinType.getName());
		}

		String bulletinName = bulletinType.getName();

		CommsBulletin bulletin = getEmailBulletin(bulletinName);

		if (bulletin != null 
				&& StringUtils.isNotBlank(bulletinName)
				&& StringUtils.isNotBlank(emailAddress)) {
			String subject = bulletin.getSubject();
			String[] toList = new String[] { emailAddress };
			String bodyText = bulletin.getCommsBulletinText();

			if (logger.isInfoEnabled()) {
				logger.info("Sending Bulletin "
						+ bulletin.getCommsBulletinName());
			}

			sendSimpleMailMessage(null, toList, null, subject, bodyText);

			if (logger.isInfoEnabled())
				logger.info("Bulletin " + bulletin.getCommsBulletinName()
						+ " sent");
		} else {
			logger.error("Bulletin " + bulletinName + " is not found.");
		}
	}

	/**
	 * Retrieve bulletin by bulletinName
	 * 
	 * @param bulletinName
	 * @return: instance of CommsBulletin
	 * @throws ServiceException
	 */
	private CommsBulletin getEmailBulletin(String bulletinName)
	        throws ServiceException {
        CommsBulletin bulletin = (CommsBulletin) bulletinTable.get(bulletinName);

        if (bulletin == null) // firt time retrieve, get it
        {
            try {
                bulletin = (CommsBulletin) dao.findEmailBulletinByName(bulletinName);
            }
            catch (DAOException daoex) {
	            logger.error(
	                    "Error to find a bulletin while sending an email bulletin",
	                    daoex);
                throw new ServiceException(
                        "Error finding Email Bulletin with name = " + bulletinName,
                        daoex);
            }

            // store the bulletin
            if (bulletin != null)
                bulletinTable.put(bulletinName, bulletin);
        }
	    
	    return bulletin;
	}

	private String getVisitedSitenames(Set personSites) {
    	String vistedSitenames = " ";
    	Set descriptions = new HashSet();
    	
    	Iterator personSitesIter = personSites.iterator();
		while (personSitesIter.hasNext()) {
			SiteIdentity siteIdentity = (SiteIdentity)personSitesIter.next();
    		VAFacility facility = siteIdentity.getVaFacility();
			String facName = facility.getDescription();
			if (facName != null) {
				descriptions.add(facName);
			}
		}

        if (descriptions.size() > 0) {
        	vistedSitenames = StringUtils.join(descriptions.toArray(), "; ");
        }
        
    	return vistedSitenames;
    }
    
    private Map constructSiteRecipientList(CommsBulletin bulletin, Map dataMap, Person person, Set personSites) throws ServiceException {
    	
    	String siteRecipientPrefixList = bulletin.getSiteRecipientPrefixList();
    	String siteReceivingIndicator = bulletin.getSiteReceivingIndicator();
    	
    	Map facilityEmailAddressMap = new HashMap();

    	if (siteRecipientPrefixList == null) {
    		return facilityEmailAddressMap;
    	}
    	
    	String[] prefixList = siteRecipientPrefixList.split(",");
    	HashSet facilities = new HashSet();
    	if (CommsBulletin.SENDING_SITE.equals(siteReceivingIndicator)) {
    			String stationNumber = (String)dataMap.get(BulletinTriggerEvent.STATION_NUMBER);
    			if (stationNumber != null) {
    				VAFacility facility = (VAFacility)this.lookupService.getByCode(VAFacility.class, stationNumber);
                    
                    if (psDelegateService.isSupportedInEnvironment(facility)) {
                        facilities.add(facility);
                    }
    			}
    	}
    	else if (CommsBulletin.VETERAN_SITES.equals(siteReceivingIndicator)) {
    		if (personSites == null) {personSites = getSites(person.getVPIDEntityKey());};
    	
	    	Iterator personSitesIter = personSites.iterator();
			while (personSitesIter.hasNext()) {
				SiteIdentity siteIdentity = (SiteIdentity)personSitesIter.next();
	    		VAFacility facility = siteIdentity.getVaFacility();
                
                if (psDelegateService.isSupportedInEnvironment(facility)) {
                    facilities.add(facility);
                }
			}
    	}
    	
    	Iterator facilitiesIter = facilities.iterator();
    	while (facilitiesIter.hasNext()) {
    		VAFacility facility =  (VAFacility)facilitiesIter.next();
    		
			String emailDomainName = null;
			
			if (facility != null) {
				emailDomainName = facility.getEmailDomainName();	
			}
			
			if (emailDomainName != null) {
		    	boolean addedOneEmail = false;
		    	StringBuffer siteRecipients = null;
				for (int i=0; i < prefixList.length; i++) {
					String emailPrefix = prefixList[i];
					emailPrefix = emailPrefix.trim();
					emailPrefix = emailPrefix.replace(' ', '_');
					String siteEmail = emailPrefix + "@" + emailDomainName;
					if (addedOneEmail == false) {
						siteRecipients = new StringBuffer(siteEmail);
						addedOneEmail = true;
					}
					else {
						if (siteRecipients != null) {
							siteRecipients.append(",");
							siteRecipients.append(siteEmail);
						}
					}		
				}
				if (siteRecipients != null)
					facilityEmailAddressMap.put(facility, siteRecipients.toString());
			}
		}
    	return facilityEmailAddressMap;
    }
    
    /**
     * Escape certain regular expression characters
     * @param name
     * @return filtered name
     */    
    private static String escapeRegExprChars(String name) {
 	   if (name == null) {
 		   return null;
 	   }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); i++) {
            char curChar = name.charAt(i);
            switch (curChar) {
	            case '\\': 
	            case '/':
	            case ',':
	            case '.':
	            case '+':
	            case '-':
	            case '"':
	            case '@':
	            case '!':
	            case '?':
	            case '<':
	            case '>':
	            case '(':
	            case ')':  
	            case '[':
	            case ']': 
                case '{':
                case '}': 	            	
	            case ';':
	            case ':':
	            case '^':
	            case '$':
	            case '*':
             	   break;
                default:
                    sb.append(curChar);
            }
        }       
        return sb.toString();
    }
    
    /**
     * Replace Parameters with Values
     * @param text
     * @param dataTable
     * @return
     */
    private String replaceParameters(String text, Hashtable dataTable){
        if (text == null || text.length() == 0)
            return text;

        Enumeration keys = dataTable.keys();

        String key = null;
        String value = null;
        String tag = null;
        String percentTag = null;
        

        if (dataTable != null && dataTable.size()> 0)
        {
            //has data for tag replacement
            while (keys.hasMoreElements()) {
                // key = (String) keys.nextElement();
                key = keys.nextElement().toString();
                if (key != null) {
                    Object obj = dataTable.get(key);
                    if (obj != null)
                        value = (String) dataTable.get(key).toString();
                    else
                        continue; //object == null, no replacement
                    
                    //Filter out regular expression characters to avoid Fortify High finding - Denial of Service: Regular Expression
                    String updatedKey = escapeRegExprChars(key);
                    
                    // if (value != null && value.length() > 0)
                    tag = "~" + updatedKey + "~";
                    text = text.replaceAll(tag, value);
                    percentTag = "<" +updatedKey + ">";
                    text = text.replaceAll(percentTag, value);
                }
            }
        }
        
        return text;
    }
    /**
     * Replace Parameter values and update Person identity traits
     * @param bodyText
     * @param dataTable
     * @param person
     * @return
     */
    private String generateEmailText(String bodyText, Hashtable dataTable,
            Person person, SiteIdentity siteIdentity) {
        if (bodyText == null || bodyText.length() == 0)
            return bodyText;

        String text = replaceParameters(bodyText, dataTable);
        
        String tag = "~" + TAG_VPID + "~";
        
        // post process by populating the VPID, DFN and Station Number 
        if (person != null) {
        	String vpid = VPID.getShortVPID(person.getVPIDEntityKey().getVPID());
        	if (siteIdentity != null) {
        		String dfn = " DFN: " + siteIdentity.getDfn() + 
        			" STATION NUMBER: " + siteIdentity.getVaFacility().getStationNumber();        		
            	text = text.replaceAll(tag,vpid + dfn);
        	}
        	else {        	
        		text = text.replaceAll(tag,vpid);
        	}
        }

        return text;
    }

    public Hashtable getEmptyBulletinDataTable(String bulletinName)
            throws ServiceException {
        Hashtable dataTab = new Hashtable();
        CommsBulletin bulletin = getEmailBulletin(bulletinName);

        if (bulletin != null && bulletin.getCommsBulletinText() != null) {
            String text = bulletin.getCommsBulletinText();
            Pattern p;

            try {
                p = Pattern.compile("~\\w+~");
            }
            catch (PatternSyntaxException pe) {
                throw new ServiceException("Can not match data element pattern", pe);
            }

            Matcher m = p.matcher(text);
            String tag = null;

            // put the data element into Hashtable
            while (m.find()) {
                tag = m.group();
                dataTab.put(tag.substring(1, tag.length() - 1), StringUtils.EMPTY);
            }
        }

        return dataTab;
    }

    public void sendSimpleMailMessage(String from, String[] toList,
            String[] ccList, String subject, String bodyText)
            throws ServiceException

    {
        SimpleMailMessage msg = new SimpleMailMessage(message);
        if(StringUtils.isNotBlank(from))
        	msg.setFrom(from);

        msg.setTo(toList);
        msg.setCc(ccList);
        //Filter out carriage return characters to avoid Fortify High finding - Header Manipulation: SMTP
    	String filteredSubject = subject;
    	if (StringUtils.isNotEmpty(subject)) {
    		filteredSubject = filteredSubject.replace("\r", "");
    		filteredSubject = filteredSubject.replace("\n", "");
    	}
        msg.setSubject(filteredSubject);

       	mailService.send(bodyText, msg);
    }

	/**
	 * @return Returns the mailService.
	 */
	public MailService getMailService() {
		return mailService;
	}

	/**
	 * @param mailService The mailService to set.
	 */
	public void setMailService(MailService mailService) {
		this.mailService = mailService;
	}
	
    public PSDelegateService getPsDelegateService() {
        return psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

	public LookupService getLookupService() {
		return lookupService;
	}

	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}
	
	public EnvironmentParamService getEnvironmentParamService() {
		return this.environmentParamService;
	}
	
	public void setEnvironmentParamService(EnvironmentParamService environmentParamService) {
		this.environmentParamService = environmentParamService;
		
	}
	
	private String getEmailDomainName(String stationNumber) {
		return (String)emailDomainNameMap.get(stationNumber);
	}
	
	private Set getSites(VPIDEntityKey vpidEntityKey) throws ServiceException{
		return psDelegateService.getSites(vpidEntityKey);
	}
	
	private Map getSiteIdentityMap(Set personSites){		
		//Loop through and create a map of facility and dfn
		Map map = new HashMap();
		if (personSites != null && personSites.size() > 0) {
			for (Iterator iter = personSites.iterator(); iter.hasNext();){
				SiteIdentity siteIdentity = (SiteIdentity)iter.next();
				map.put(siteIdentity.getVaFacility(), siteIdentity);
			}
		}
		return map;
	}
    // Need to move data in emailDomainNameMap into xml
	private static HashMap emailDomainNameMap = new HashMap();
	
	static {
		//emailDomainName = (String)emailDomainNameMap.get(getStationNumber());
		// SQA testing site domains
		emailDomainNameMap.put("358", "MANILA.TEST");
		emailDomainNameMap.put("402", "TOGUS.TEST");
		emailDomainNameMap.put("405", "WHITE-RIVER.TEST");
		emailDomainNameMap.put("436", "MONTANA.TEST");
		emailDomainNameMap.put("437", "FARGO.TEST");
		emailDomainNameMap.put("438", "SIOUX-FALLS.TEST");
		emailDomainNameMap.put("442", "CHEYENNE.TEST");
		emailDomainNameMap.put("452", "WICHITA.TEST");
		emailDomainNameMap.put("459", "HONOLULU.TEST");
		emailDomainNameMap.put("460", "WILMINGTON.TEST");
		emailDomainNameMap.put("463", "ANCHORAGE.TEST");
		emailDomainNameMap.put("500", "ALBANY.TEST");
		emailDomainNameMap.put("501", "ALBUQUERQUE.TEST");
		emailDomainNameMap.put("502", "ALEXANDRIA.TEST");
		emailDomainNameMap.put("503", "ALTOONA.TEST");
		emailDomainNameMap.put("504", "AMARILLO.TEST");
		emailDomainNameMap.put("505", "TACOMA.TEST");
		emailDomainNameMap.put("506", "ANN-ARBOR.TEST");
		emailDomainNameMap.put("508", "ATLANTA.TEST");
		emailDomainNameMap.put("509", "AUGUSTA.TEST");
		emailDomainNameMap.put("512", "BALTIMORE.TEST");
		emailDomainNameMap.put("513", "BATAVIA.TEST");
		emailDomainNameMap.put("514", "BATH.TEST");
		emailDomainNameMap.put("515", "BATTLE-CREEK.TEST");
		emailDomainNameMap.put("516", "BAY-PINES.TEST");
		emailDomainNameMap.put("517", "BECKLEY.TEST");
		emailDomainNameMap.put("518", "BEDFORD.TEST");
		emailDomainNameMap.put("519", "BIG-SPRING.TEST");
		emailDomainNameMap.put("520", "BILOXI.TEST");
		emailDomainNameMap.put("521", "BIRMINGHAM.TEST");
		emailDomainNameMap.put("522", "BONHAM.TEST");
		emailDomainNameMap.put("523", "BOSTON.TEST");
		emailDomainNameMap.put("525", "BROCKTON.TEST");
		emailDomainNameMap.put("526", "BRONX.TEST");
		emailDomainNameMap.put("527", "BROOKLYN.TEST");
		emailDomainNameMap.put("528", "V02.TEST");
		emailDomainNameMap.put("529", "BUTLER.TEST");
		emailDomainNameMap.put("531", "BOISE.TEST");
		emailDomainNameMap.put("532", "CANANDAIGUA.TEST");
		emailDomainNameMap.put("533", "CASTLE-POINT.TEST");
		emailDomainNameMap.put("534", "CHARLESTON.TEST");
		emailDomainNameMap.put("535", "CHICAGO-LAKE.TEST");
		emailDomainNameMap.put("537", "CHICAGO-WEST.TEST");
		emailDomainNameMap.put("538", "CHILLICOTHE.TEST");
		emailDomainNameMap.put("539", "CINCINNATI.TEST");
		emailDomainNameMap.put("540", "CLARKSBURG.TEST");
		emailDomainNameMap.put("541", "CLEVELAND.TEST");
		emailDomainNameMap.put("542", "COATESVILLE.TEST");
		emailDomainNameMap.put("543", "COLUMBIA-MO.TEST");
		emailDomainNameMap.put("544", "COLUMBIA-SC.TEST");
		emailDomainNameMap.put("546", "MIAMI.TEST");
		emailDomainNameMap.put("549", "DALLAS.TEST");
		emailDomainNameMap.put("550", "DANVILLE.TEST");
		emailDomainNameMap.put("552", "DAYTON.TEST");
		emailDomainNameMap.put("553", "DETROIT.TEST");
		emailDomainNameMap.put("554", "DENVER.TEST");
		emailDomainNameMap.put("555", "DES-MOINES.TEST");
		emailDomainNameMap.put("556", "N-CHICAGO.TEST");
		emailDomainNameMap.put("557", "DUBLIN.TEST");
		emailDomainNameMap.put("558", "DURHAM.TEST");
		emailDomainNameMap.put("561", "EAST-ORANGE.TEST");
		emailDomainNameMap.put("562", "ERIE.TEST");
		emailDomainNameMap.put("564", "FAYETTVL-AR.TEST");
		emailDomainNameMap.put("565", "FAYETTVL-NC.TEST");
		emailDomainNameMap.put("566", "FORT-HOWARD.TEST");
		emailDomainNameMap.put("567", "FORT-LYON.TEST");
		emailDomainNameMap.put("568", "BLACK-HILLS.TEST");
		emailDomainNameMap.put("569", "FORT-WAYNE.TEST");
		emailDomainNameMap.put("570", "FRESNO.TEST");
		emailDomainNameMap.put("573", "NORTH-FLORIDA.TEST");
		emailDomainNameMap.put("574", "GRAND-ISLAND.TEST");
		emailDomainNameMap.put("575", "GRAND-JUNCT.TEST");
		emailDomainNameMap.put("578", "HINES.TEST");
		emailDomainNameMap.put("579", "HOT-SPRINGS.TEST");
		emailDomainNameMap.put("580", "HOUSTON.TEST");
		emailDomainNameMap.put("581", "HUNTINGTON.TEST");
		emailDomainNameMap.put("583", "INDIANAPOLIS.TEST");
		emailDomainNameMap.put("584", "IOWA-CITY.TEST");
		emailDomainNameMap.put("585", "IRON-MTN.TEST");
		emailDomainNameMap.put("586", "JACKSON.TEST");
		emailDomainNameMap.put("589", "KANSAS-CITY.TEST");
		emailDomainNameMap.put("590", "HAMPTON.TEST");
		emailDomainNameMap.put("591", "KERRVILLE.TEST");
		emailDomainNameMap.put("594", "LAKE-CITY.TEST");
		emailDomainNameMap.put("595", "LEBANON.TEST");
		emailDomainNameMap.put("596", "LEXINGTON.TEST");
		emailDomainNameMap.put("597", "LINCOLN.TEST");
		emailDomainNameMap.put("598", "LITTLE-ROCK.TEST");
		emailDomainNameMap.put("599", "LIVERMORE.TEST");
		emailDomainNameMap.put("600", "LONG-BEACH.TEST");
		emailDomainNameMap.put("603", "LOUISVILLE.TEST");
		emailDomainNameMap.put("604", "LYONS.TEST");
		emailDomainNameMap.put("605", "LOMA-LINDA.TEST");
		emailDomainNameMap.put("607", "MADISON.TEST");
		emailDomainNameMap.put("608", "MANCHESTER.TEST");
		emailDomainNameMap.put("609", "MARION-IL.TEST");
		emailDomainNameMap.put("610", "NORTHERN-INDIANA.TEST");
		emailDomainNameMap.put("611", "MARLIN.TEST");
		emailDomainNameMap.put("612", "MARTINEZ.TEST");
		emailDomainNameMap.put("613", "MART6.DNS        .MED.DNS   ");
		emailDomainNameMap.put("614", "MEMPHIS.TEST");
		emailDomainNameMap.put("617", "MILES-CITY.TEST");
		emailDomainNameMap.put("618", "MINNEAPOLIS.TEST");
		emailDomainNameMap.put("619", "CENTRAL-ALABAMA.TEST");
		emailDomainNameMap.put("620", "MONTROSE.TEST");
		emailDomainNameMap.put("621", "MTN-HOME.TEST");
		emailDomainNameMap.put("622", "MURFREESBORO.TEST");
		emailDomainNameMap.put("623", "MUSKOGEE.TEST");
		emailDomainNameMap.put("626", "TENNESSEEVALLEY.TEST");
		emailDomainNameMap.put("627", "NEWINGTON.TEST");
		emailDomainNameMap.put("629", "NEW-ORLEANS.TEST");
		emailDomainNameMap.put("630", "NY-HARBOR.TEST");
		emailDomainNameMap.put("631", "NORTHAMPTON.TEST");
		emailDomainNameMap.put("632", "NORTHPORT.TEST");
		emailDomainNameMap.put("635", "OKLAHOMA.TEST");
		emailDomainNameMap.put("636", "CENTRAL-PLAINS.TEST");
		emailDomainNameMap.put("637", "ASHEVILLE.TEST");
		emailDomainNameMap.put("640", "PALO-ALTO.TEST");
		emailDomainNameMap.put("641", "PERRY-POINT.TEST");
		emailDomainNameMap.put("642", "PHILADELPHIA.TEST");
		emailDomainNameMap.put("644", "PHOENIX.TEST");
		emailDomainNameMap.put("645", "PITTS-HGHLND.TEST");
		emailDomainNameMap.put("646", "PITTSBURGH.TEST");
		emailDomainNameMap.put("647", "POPLAR-BLUFF.TEST");
		emailDomainNameMap.put("648", "PORTLAND.TEST");
		emailDomainNameMap.put("649", "PRESCOTT.TEST");
		emailDomainNameMap.put("650", "PROVIDENCE.TEST");
		emailDomainNameMap.put("652", "RICHMOND.TEST");
		emailDomainNameMap.put("653", "ROSEBURG.TEST");
		emailDomainNameMap.put("654", "RENO.TEST");
		emailDomainNameMap.put("655", "SAGINAW.TEST");
		emailDomainNameMap.put("656", "ST-CLOUD.TEST");
		emailDomainNameMap.put("657", "ST-LOUIS.TEST");
		emailDomainNameMap.put("658", "SALEM.TEST");
		emailDomainNameMap.put("659", "SALISBURY.TEST");
		emailDomainNameMap.put("660", "SALT-LAKE.TEST");
		emailDomainNameMap.put("662", "SANFRANCISCO.TEST");
		emailDomainNameMap.put("663", "PUGET-SOUND.TEST");
		emailDomainNameMap.put("664", "SAN-DIEGO.TEST");
		emailDomainNameMap.put("665", "SEPULVEDA.TEST");
		emailDomainNameMap.put("666", "SHERIDAN.TEST");
		emailDomainNameMap.put("667", "SHREVEPORT.TEST");
		emailDomainNameMap.put("668", "SPOKANE.TEST");
		emailDomainNameMap.put("670", "SYRACUSE.TEST");
		emailDomainNameMap.put("671", "SAN-ANTONIO.TEST");
		emailDomainNameMap.put("672", "SAN-JUAN.TEST");
		emailDomainNameMap.put("673", "TAMPA.TEST");
		emailDomainNameMap.put("674", "CENTRAL-TEXAS.TEST");
		emailDomainNameMap.put("676", "TOMAH.TEST");
		emailDomainNameMap.put("677", "TOPEKA.TEST");
		emailDomainNameMap.put("678", "TUCSON.TEST");
		emailDomainNameMap.put("679", "TUSCALOOSA.TEST");
		emailDomainNameMap.put("680", "TUSKEGEE.TEST");
		emailDomainNameMap.put("685", "WACO.TEST");
		emailDomainNameMap.put("686", "LEAVENWORTH.TEST");
		emailDomainNameMap.put("687", "WALLA-WALLA.TEST");
		emailDomainNameMap.put("688", "WASHINGTON.TEST");
		emailDomainNameMap.put("689", "WEST-HAVEN.TEST");
		emailDomainNameMap.put("691", "WEST-LA.TEST");
		emailDomainNameMap.put("692", "WHITE-CITY.TEST");
		emailDomainNameMap.put("693", "WILKES-BARRE.TEST");
		emailDomainNameMap.put("695", "MILWAUKEE.TEST");
		emailDomainNameMap.put("752", "LA-OPC.TEST");
		emailDomainNameMap.put("756", "EL-PASO.TEST");
		emailDomainNameMap.put("757", "COLUMBUS.TEST");
		emailDomainNameMap.put("758", "LAS-VEGAS.TEST");
		emailDomainNameMap.put("954", "DNS   ");
		emailDomainNameMap.put("555A4", "KNOXVILLE.TEST");
		emailDomainNameMap.put("987",	"CHEY6.DNS        .MED.DNS   ");
		emailDomainNameMap.put("988",	"DAYT20.DNS        .MED.DNS   ");
		emailDomainNameMap.put("983",	"CHYSHR.DNS        .MED.DNS   ");
		emailDomainNameMap.put("984",	"DAYTSHR.DNS        .MED.DNS   ");
		
		/* production site domains
		emailDomainNameMap.put("358", "MANILA.MED.DNS   ");
		emailDomainNameMap.put("402", "TOGUS.MED.DNS   ");
		emailDomainNameMap.put("405", "WHITE-RIVER.MED.DNS   ");
		emailDomainNameMap.put("436", "MONTANA.MED.DNS   ");
		emailDomainNameMap.put("437", "FARGO.MED.DNS   ");
		emailDomainNameMap.put("438", "SIOUX-FALLS.MED.DNS   ");
		emailDomainNameMap.put("442", "CHEYENNE.MED.DNS   ");
		emailDomainNameMap.put("452", "WICHITA.MED.DNS   ");
		emailDomainNameMap.put("459", "HONOLULU.MED.DNS   ");
		emailDomainNameMap.put("460", "WILMINGTON.MED.DNS   ");
		emailDomainNameMap.put("463", "ANCHORAGE.MED.DNS   ");
		emailDomainNameMap.put("500", "ALBANY.MED.DNS   ");
		emailDomainNameMap.put("501", "ALBUQUERQUE.MED.DNS   ");
		emailDomainNameMap.put("502", "ALEXANDRIA.MED.DNS   ");
		emailDomainNameMap.put("503", "ALTOONA.MED.DNS   ");
		emailDomainNameMap.put("504", "AMARILLO.MED.DNS   ");
		emailDomainNameMap.put("505", "TACOMA.MED.DNS   ");
		emailDomainNameMap.put("506", "ANN-ARBOR.MED.DNS   ");
		emailDomainNameMap.put("508", "ATLANTA.MED.DNS   ");
		emailDomainNameMap.put("509", "AUGUSTA.MED.DNS   ");
		emailDomainNameMap.put("512", "BALTIMORE.MED.DNS   ");
		emailDomainNameMap.put("513", "BATAVIA.MED.DNS   ");
		emailDomainNameMap.put("514", "BATH.MED.DNS   ");
		emailDomainNameMap.put("515", "BATTLE-CREEK.MED.DNS   ");
		emailDomainNameMap.put("516", "BAY-PINES.MED.DNS   ");
		emailDomainNameMap.put("517", "BECKLEY.MED.DNS   ");
		emailDomainNameMap.put("518", "BEDFORD.MED.DNS   ");
		emailDomainNameMap.put("519", "BIG-SPRING.MED.DNS   ");
		emailDomainNameMap.put("520", "BILOXI.MED.DNS   ");
		emailDomainNameMap.put("521", "BIRMINGHAM.MED.DNS   ");
		emailDomainNameMap.put("522", "BONHAM.MED.DNS   ");
		emailDomainNameMap.put("523", "BOSTON.MED.DNS   ");
		emailDomainNameMap.put("525", "BROCKTON.MED.DNS   ");
		emailDomainNameMap.put("526", "BRONX.MED.DNS   ");
		emailDomainNameMap.put("527", "BROOKLYN.MED.DNS   ");
		emailDomainNameMap.put("528", "V02.MED.DNS   ");
		emailDomainNameMap.put("529", "BUTLER.MED.DNS   ");
		emailDomainNameMap.put("531", "BOISE.MED.DNS   ");
		emailDomainNameMap.put("532", "CANANDAIGUA.MED.DNS   ");
		emailDomainNameMap.put("533", "CASTLE-POINT.MED.DNS   ");
		emailDomainNameMap.put("534", "CHARLESTON.MED.DNS   ");
		emailDomainNameMap.put("535", "CHICAGO-LAKE.MED.DNS   ");
		emailDomainNameMap.put("537", "CHICAGO-WEST.MED.DNS   ");
		emailDomainNameMap.put("538", "CHILLICOTHE.MED.DNS   ");
		emailDomainNameMap.put("539", "CINCINNATI.MED.DNS   ");
		emailDomainNameMap.put("540", "CLARKSBURG.MED.DNS   ");
		emailDomainNameMap.put("541", "CLEVELAND.MED.DNS   ");
		emailDomainNameMap.put("542", "COATESVILLE.MED.DNS   ");
		emailDomainNameMap.put("543", "COLUMBIA-MO.MED.DNS   ");
		emailDomainNameMap.put("544", "COLUMBIA-SC.MED.DNS   ");
		emailDomainNameMap.put("546", "MIAMI.MED.DNS   ");
		emailDomainNameMap.put("549", "DALLAS.MED.DNS   ");
		emailDomainNameMap.put("550", "DANVILLE.MED.DNS   ");
		emailDomainNameMap.put("552", "DAYTON.MED.DNS   ");
		emailDomainNameMap.put("553", "DETROIT.MED.DNS   ");
		emailDomainNameMap.put("554", "DENVER.MED.DNS   ");
		emailDomainNameMap.put("555", "DES-MOINES.MED.DNS   ");
		emailDomainNameMap.put("556", "N-CHICAGO.MED.DNS   ");
		emailDomainNameMap.put("557", "DUBLIN.MED.DNS   ");
		emailDomainNameMap.put("558", "DURHAM.MED.DNS   ");
		emailDomainNameMap.put("561", "EAST-ORANGE.MED.DNS   ");
		emailDomainNameMap.put("562", "ERIE.MED.DNS   ");
		emailDomainNameMap.put("564", "FAYETTVL-AR.MED.DNS   ");
		emailDomainNameMap.put("565", "FAYETTVL-NC.MED.DNS   ");
		emailDomainNameMap.put("566", "FORT-HOWARD.MED.DNS   ");
		emailDomainNameMap.put("567", "FORT-LYON.MED.DNS   ");
		emailDomainNameMap.put("568", "BLACK-HILLS.MED.DNS   ");
		emailDomainNameMap.put("569", "FORT-WAYNE.MED.DNS   ");
		emailDomainNameMap.put("570", "FRESNO.MED.DNS   ");
		emailDomainNameMap.put("573", "NORTH-FLORIDA.MED.DNS   ");
		emailDomainNameMap.put("574", "GRAND-ISLAND.MED.DNS   ");
		emailDomainNameMap.put("575", "GRAND-JUNCT.MED.DNS   ");
		emailDomainNameMap.put("578", "HINES.MED.DNS   ");
		emailDomainNameMap.put("579", "HOT-SPRINGS.MED.DNS   ");
		emailDomainNameMap.put("580", "HOUSTON.MED.DNS   ");
		emailDomainNameMap.put("581", "HUNTINGTON.MED.DNS   ");
		emailDomainNameMap.put("583", "INDIANAPOLIS.MED.DNS   ");
		emailDomainNameMap.put("584", "IOWA-CITY.MED.DNS   ");
		emailDomainNameMap.put("585", "IRON-MTN.MED.DNS   ");
		emailDomainNameMap.put("586", "JACKSON.MED.DNS   ");
		emailDomainNameMap.put("589", "KANSAS-CITY.MED.DNS   ");
		emailDomainNameMap.put("590", "HAMPTON.MED.DNS   ");
		emailDomainNameMap.put("591", "KERRVILLE.MED.DNS   ");
		emailDomainNameMap.put("594", "LAKE-CITY.MED.DNS   ");
		emailDomainNameMap.put("595", "LEBANON.MED.DNS   ");
		emailDomainNameMap.put("596", "LEXINGTON.MED.DNS   ");
		emailDomainNameMap.put("597", "LINCOLN.MED.DNS   ");
		emailDomainNameMap.put("598", "LITTLE-ROCK.MED.DNS   ");
		emailDomainNameMap.put("599", "LIVERMORE.MED.DNS   ");
		emailDomainNameMap.put("600", "LONG-BEACH.MED.DNS   ");
		emailDomainNameMap.put("603", "LOUISVILLE.MED.DNS   ");
		emailDomainNameMap.put("604", "LYONS.MED.DNS   ");
		emailDomainNameMap.put("605", "LOMA-LINDA.MED.DNS   ");
		emailDomainNameMap.put("607", "MADISON.MED.DNS   ");
		emailDomainNameMap.put("608", "MANCHESTER.MED.DNS   ");
		emailDomainNameMap.put("609", "MARION-IL.MED.DNS   ");
		emailDomainNameMap.put("610", "NORTHERN-INDIANA.MED.DNS   ");
		emailDomainNameMap.put("611", "MARLIN.MED.DNS   ");
		emailDomainNameMap.put("612", "MARTINEZ.MED.DNS   ");
		emailDomainNameMap.put("613", "MARTINSBURG.MED.DNS   ");
		emailDomainNameMap.put("614", "MEMPHIS.MED.DNS   ");
		emailDomainNameMap.put("617", "MILES-CITY.MED.DNS   ");
		emailDomainNameMap.put("618", "MINNEAPOLIS.MED.DNS   ");
		emailDomainNameMap.put("619", "CENTRAL-ALABAMA.MED.DNS   ");
		emailDomainNameMap.put("620", "MONTROSE.MED.DNS   ");
		emailDomainNameMap.put("621", "MTN-HOME.MED.DNS   ");
		emailDomainNameMap.put("622", "MURFREESBORO.MED.DNS   ");
		emailDomainNameMap.put("623", "MUSKOGEE.MED.DNS   ");
		emailDomainNameMap.put("626", "TENNESSEEVALLEY.MED.DNS   ");
		emailDomainNameMap.put("627", "NEWINGTON.MED.DNS   ");
		emailDomainNameMap.put("629", "NEW-ORLEANS.MED.DNS   ");
		emailDomainNameMap.put("630", "NY-HARBOR.MED.DNS   ");
		emailDomainNameMap.put("631", "NORTHAMPTON.MED.DNS   ");
		emailDomainNameMap.put("632", "NORTHPORT.MED.DNS   ");
		emailDomainNameMap.put("635", "OKLAHOMA.MED.DNS   ");
		emailDomainNameMap.put("636", "CENTRAL-PLAINS.MED.DNS   ");
		emailDomainNameMap.put("637", "ASHEVILLE.MED.DNS   ");
		emailDomainNameMap.put("640", "PALO-ALTO.MED.DNS   ");
		emailDomainNameMap.put("641", "PERRY-POINT.MED.DNS   ");
		emailDomainNameMap.put("642", "PHILADELPHIA.MED.DNS   ");
		emailDomainNameMap.put("644", "PHOENIX.MED.DNS   ");
		emailDomainNameMap.put("645", "PITTS-HGHLND.MED.DNS   ");
		emailDomainNameMap.put("646", "PITTSBURGH.MED.DNS   ");
		emailDomainNameMap.put("647", "POPLAR-BLUFF.MED.DNS   ");
		emailDomainNameMap.put("648", "PORTLAND.MED.DNS   ");
		emailDomainNameMap.put("649", "PRESCOTT.MED.DNS   ");
		emailDomainNameMap.put("650", "PROVIDENCE.MED.DNS   ");
		emailDomainNameMap.put("652", "RICHMOND.MED.DNS   ");
		emailDomainNameMap.put("653", "ROSEBURG.MED.DNS   ");
		emailDomainNameMap.put("654", "RENO.MED.DNS   ");
		emailDomainNameMap.put("655", "SAGINAW.MED.DNS   ");
		emailDomainNameMap.put("656", "ST-CLOUD.MED.DNS   ");
		emailDomainNameMap.put("657", "ST-LOUIS.MED.DNS   ");
		emailDomainNameMap.put("658", "SALEM.MED.DNS   ");
		emailDomainNameMap.put("659", "SALISBURY.MED.DNS   ");
		emailDomainNameMap.put("660", "SALT-LAKE.MED.DNS   ");
		emailDomainNameMap.put("662", "SANFRANCISCO.MED.DNS   ");
		emailDomainNameMap.put("663", "PUGET-SOUND.MED.DNS   ");
		emailDomainNameMap.put("664", "SAN-DIEGO.MED.DNS   ");
		emailDomainNameMap.put("665", "SEPULVEDA.MED.DNS   ");
		emailDomainNameMap.put("666", "SHERIDAN.MED.DNS   ");
		emailDomainNameMap.put("667", "SHREVEPORT.MED.DNS   ");
		emailDomainNameMap.put("668", "SPOKANE.MED.DNS   ");
		emailDomainNameMap.put("670", "SYRACUSE.MED.DNS   ");
		emailDomainNameMap.put("671", "SAN-ANTONIO.MED.DNS   ");
		emailDomainNameMap.put("672", "SAN-JUAN.MED.DNS   ");
		emailDomainNameMap.put("673", "TAMPA.MED.DNS   ");
		emailDomainNameMap.put("674", "CENTRAL-TEXAS.MED.DNS   ");
		emailDomainNameMap.put("676", "TOMAH.MED.DNS   ");
		emailDomainNameMap.put("677", "TOPEKA.MED.DNS   ");
		emailDomainNameMap.put("678", "TUCSON.MED.DNS   ");
		emailDomainNameMap.put("679", "TUSCALOOSA.MED.DNS   ");
		emailDomainNameMap.put("680", "TUSKEGEE.MED.DNS   ");
		emailDomainNameMap.put("685", "WACO.MED.DNS   ");
		emailDomainNameMap.put("686", "LEAVENWORTH.MED.DNS   ");
		emailDomainNameMap.put("687", "WALLA-WALLA.MED.DNS   ");
		emailDomainNameMap.put("688", "WASHINGTON.MED.DNS   ");
		emailDomainNameMap.put("689", "WEST-HAVEN.MED.DNS   ");
		emailDomainNameMap.put("691", "WEST-LA.MED.DNS   ");
		emailDomainNameMap.put("692", "WHITE-CITY.MED.DNS   ");
		emailDomainNameMap.put("693", "WILKES-BARRE.MED.DNS   ");
		emailDomainNameMap.put("695", "MILWAUKEE.MED.DNS   ");
		emailDomainNameMap.put("752", "LA-OPC.MED.DNS   ");
		emailDomainNameMap.put("756", "EL-PASO.MED.DNS   ");
		emailDomainNameMap.put("757", "COLUMBUS.MED.DNS   ");
		emailDomainNameMap.put("758", "LAS-VEGAS.MED.DNS   ");
		emailDomainNameMap.put("954", "RMEC-DURHAM.MED.DNS   ");
		emailDomainNameMap.put("555A4", "KNOXVILLE.MED.DNS   ");
		*/
	}
}
