/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.service.impl;

// Java classes
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;

import java.sql.Timestamp;

import org.apache.commons.lang.builder.ToStringBuilder;

// EDB classes

/**
 * Project: Common
 * 
 * @author DNS   LEV
 * @version 1.0
 */
public class ChangeEvent extends AbstractEntity implements Comparable {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3886161676308834655L;

	private Timestamp timeStamp = null;

	private EntityKey entityKey;

    private ChangeEvent prevousChangeEvent;
    
	public ChangeEvent(EntityKey entityKey) {
		this();
		this.entityKey = entityKey;
	}

	/**
	 */
	public ChangeEvent() {
		super();
		this.timeStamp = new Timestamp(System.currentTimeMillis());
	}

	/**
	 * @param timeStamp
	 */
	public ChangeEvent(Timestamp timeStamp) {
		super();
		this.timeStamp = timeStamp;
	}

	/**
	 * @param timeStamp
	 */
	public ChangeEvent(Timestamp timeStamp, EntityKey entityKey) {
		this(timeStamp);
		this.entityKey = entityKey;
	}

	/**
	 * @return Returns the entityKey.
	 */
	public EntityKey getEntityKey() {
		return entityKey;
	}

	/**
	 * @return Returns the timeStamp.
	 */
	public Timestamp getTimeStamp() {
		return this.timeStamp;
	}

	/**
     * @return Returns the prevousChangeEvent.
     */
    public ChangeEvent getPrevousChangeEvent() {
        return this.prevousChangeEvent;
    }

    /**
     * @param prevousChangeEvent The prevousChangeEvent to set.
     */
    public void setPrevousChangeEvent(ChangeEvent prevousChangeEvent) {
        this.prevousChangeEvent = prevousChangeEvent;
    }

    /**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("time stamp", timeStamp);
		builder.append("entityKey", entityKey);
	}
	
	/**
	 * Compares this object with the specified object for order. Returns a
	 * negative integer, zero, or a positive integer as this object is less
	 * than, equal to, or greater than the specified object.
	 * 
	 * @param o
	 * @return
	 */
	public int compareTo(Object o) {
		// same pattern as java.lang pacakge (allow for ClassCastException)
		return compareTo((ChangeEvent) o);
	}

	/**
	 * Compares this object with the specified object for order. Returns a
	 * negative integer, zero, or a positive integer as this object is less
	 * than, equal to, or greater than the specified object.
	 * 
	 * @param o
	 * @return
	 */
	
	public int compareTo(ChangeEvent o) {
		int val = 0;
		if (o == null)
			val = -1;
		else if (!equals(o)) {
			val = timeStamp.compareTo(o.getTimeStamp());
		}
		return val;
	}


}
