/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.impl;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Allows for isolation logging to a separate log file for all CAIP invocations
 * 
 * Created Oct 13, 2006 2:13:27 PM
 * @author DNS   BOHMEG
 */
public class CAIPDelegatedServiceAdvice extends AbstractComponent implements
		MethodInterceptor {

	/* (non-Javadoc)
	 * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
	 */
	public Object invoke(MethodInvocation arg0) throws Throwable {
		try {
			return arg0.proceed();
		} catch(Exception e) {
			logger.error("Exception in CAIPDelegatedService method", e);
			throw e;
		}
	}
}
