/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.impl;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.service.AbstractComponent;

import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.caip.client.factory.BusinessDelegateFactory;

/**
 * Abstract class for services that are CAIP-aware.
 * 
 * Created Apr 11, 2006 10:19:04 AM
 * @author DNS   BOHMEG
 */
public abstract class CAIPDelegatedService extends AbstractComponent {
	private String businessDelegateName;

	/**
	 * @return Returns the businessDelegateName.
	 */
	public String getBusinessDelegateName() {
		return businessDelegateName;
	}

	/**
	 * @param businessDelegateName The businessDelegateName to set.
	 */
	public void setBusinessDelegateName(String businessDelegateName) {
		this.businessDelegateName = businessDelegateName;
	}
	
	/** Get a handle to CAIP Delegate */
	protected Object getCAIPDelegate() throws CaipInvocationException {
		try {
			return BusinessDelegateFactory.getBusinessDelegate(businessDelegateName);
		} catch (Exception e) {
			throw new CaipInvocationException("Unable to get CAIP Delegate with name: " + businessDelegateName, e);
		}
	}		
	
	public void afterPropertiesSet() {
		Validate.notNull(businessDelegateName);
	}
}
