/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

// Java classes
import java.util.Set;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.esr.common.persistent.history.HistoryDAO;

// EDB classes

/**
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public abstract class AbstractHistoricalInfoServiceImpl extends AbstractRuleAwareServiceImpl {
   
	/**
	 * HistoryDAO that retrieves the history data.
	 */
	private HistoryDAO         historyDAO                    = null;


   /**
    * A default constructor 
    */
   protected AbstractHistoricalInfoServiceImpl() {
      super();
   }

   /**
    * @param key
    * @return Set<ChangeEvent> 
    * @throws ServiceException
    */
   public Set getHistoryChangeTimes( EntityKey key ) throws ServiceException {
	   	try {
		   return getHistoryDAO().getHistoryChangeTimes(key);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(),e);
		}    	
   }
   
   /**
    * @param event
    * @return
    * @throws ServiceException
    */
   public HistoricalInfo getHistoryByChangeTime(ChangeEvent event)
			throws ServiceException {
		try {
			return getHistoryDAO().getHistoryByChangeTime(event);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
   
	
   /**
	 * 
	 * @return
	 */
	public HistoryDAO getHistoryDAO() {
		return historyDAO;
	}

	/**
	 * 
	 * @param historyDAO
	 */
	public void setHistoryDAO(HistoryDAO historyDAO) {
		this.historyDAO = historyDAO;
	}
}