/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.service.AbstractComponent;

// EDB classes
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonService;

/**
 * This service is a base class for all internal and external services
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public abstract class AbstractHelperServiceImpl extends AbstractComponent {

    /**
     * An instance of a helper service
     */
    private PersonHelperService helperService = null;

    private LookupService lookupService = null;
    
    private PersonService personService = null;
    
    protected AbstractHelperServiceImpl() {
        super();
    }
    
    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception {
       super.afterPropertiesSet();
       Validate.notNull( lookupService, "Missing required lookup service" );
       Validate.notNull( helperService,"Missing required helper service" );
    }
    
    /**
     * @return Returns the helperService.
     */
    public PersonHelperService getHelperService() {
        return helperService;
    }
    /**
     * @param helperService The helperService to set.
     */
    public void setHelperService(PersonHelperService helperService) {
        this.helperService = helperService;
    }
    /**
     * @return Returns the lookupService.
     */
    public LookupService getLookupService() {
        return lookupService;
    }
    /**
     * @param lookupService The lookupService to set.
     */
    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    /**
     * @return Returns the personService.
     */
    public PersonService getPersonService() {
        return personService;
    }

    /**
     * @param personService The personService to set.
     */
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }


}