/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.external.person.ejb;

import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilitySummary;

import gov.va.med.esr.service.external.person.IVMSummary;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.SimpleEligibilitySummary;
import gov.va.med.esr.service.external.person.VPIDEntityKey;

import java.rmi.RemoteException;

import javax.ejb.EJBObject;

/**
 * Initial javadoc for class RemotePersonService. TODO - Add content here
 *
 * Created Jan 3, 2006 3:34:11 PM
 *
 * @author DNS   BOHMEG
 */
public interface RemotePersonService extends EJBObject {
	/** HealtheVet terminology that equates to ESR "merge" */
	public void link(VPIDEntityKey deprecatedVPID, VPIDEntityKey survivingVPID)
			throws ESRException, RemoteException;

	/** HealtheVet terminology that equates to ESR "unmerge" */
	public void move(String dfn, String stationNumber, VPIDEntityKey fromVpid,
			VPIDEntityKey toVpid) throws ESRException, RemoteException;

	/** Api for HealtheVet systems to obtain EE data for an enumerated Person */
	public EligibilitySummary getEligibilitySummary(VPIDEntityKey vpid)
			throws ESRException, RemoteException;

	/**
	 * API for Canteen System to get the veteran indicator
	 * @param ssn
	 * @return {@link SimpleEligibilitySummary}
	 * @throws ESRException
	 */
	public SimpleEligibilitySummary getSimpleEligibilitySummary(String ssn) throws ESRException, RemoteException;

	

	/**
	 * EESummary by ssn or vpid for ESR Web Services
	 * @param finder
	 * @return
	 * @throws ESRException
	 * @throws RemoteException
	 */
	public EESummary getEESummary(EntityFinder finder)
	throws ESRException, RemoteException;

	/**
	 * MSSummary by ssn or vpid for ESR Web Services
	 * @param finder
	 * @return
	 * @throws ESRException
	 * @throws RemoteException
	 */
	public MSSummary getMSSummary(EntityFinder finder)
	throws ESRException, RemoteException;


    /**
     * EESummary by ssn or vpid for ESR Web Services
     * @param finder
     * @return
     * @throws ESRException
     * @throws RemoteException
     */
    public EESummary getEESummaryHistory(EntityFinder finder)
    throws ESRException, RemoteException;

    /**
     * EESummary by ssn or vpid for ESR Web Services
     * @param finder
     * @return
     * @throws ESRException
     * @throws RemoteException
     */
    public EESummary getEDStatus(EntityFinder finder)
    throws ESRException, RemoteException;

    /**
     * EESummary by ssn or vpid for ESR Web Services
     * @param finder
     * @return
     * @throws ESRException
     * @throws RemoteException
     */
    public EESummary getPersonNotificationStatus(EntityFinder finder)
    throws ESRException, RemoteException;

    /**
     * EESummary by ssn or vpid for ESR Web Services
     * @param finder
     * @return
     * @throws ESRException
     * @throws RemoteException
     */
    public EESummary getDeliveryPreference(EntityFinder finder)
    throws ESRException, RemoteException;

    /**
     * EESummary by ssn or vpid for ESR Web Services
     * @param finder
     * @return
     * @throws ESRException
     * @throws RemoteException
     */
    public EESummary updateDeliveryPreference(EntityFinder finder)
    throws ESRException, RemoteException;

    public IVMSummary retrieveIVMCandidates(EntityFinder finder)
	throws ESRException, RemoteException;

    public IVMSummary retrieveIVMLetterCandidates() throws ESRException, RemoteException;

    public IVMSummary updateIVMStatus(EntityFinder finder)
	throws ESRException, RemoteException;

    //TODO Meena: verify and confirm return type
    public IVMSummary processIVMIncomeTest(EntityFinder finder)
	throws ESRException, RemoteException;

}
