package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.person.collections.RatedDisabilityCollection;

import java.util.Date;

public class ServiceConnectionAwardInfo extends ExternalComponent {


	private static final long serialVersionUID = 4988857997542965553L;

	/**
	 * SC Percent is defined as the combined service-connected percentage. Field
	 * may not be deleted as long as service connection is indicated and rated
	 * disabilities exist.
	 * ZSP/3/Z11
	 */
	private Integer serviceConnectedPercentage = null;

	/**
	 * ServiceConnected Indicator is defined as a code that indicates if this patient
	 * has award for service connect by the VARO due to a service connected condition
	 * ZSP/2/Z11
	 */
	private Boolean serviceConnectedIndicator = null;

	//ZSP/11/Z11
	private String combinedServiceConnectedPercentageEffectiveDate;

	/**
	 * Unemployable Indicator is defined as a code that indicates if this patient
	 * is rated unemployable by the VARO due to a service connected condition
	 * ZSP/7/Z11
	 */
	private Boolean unemployable = null;

	/**
	 * Permanent & Total Indicator is defined as a code that indicates if the
	 * patient is permanently and totally disabled determined by VARO due to a
	 * service-connected condition.
	 * ZSP/6/Z11
	 */
	private Boolean permanentAndTotal = null;

	//ZSP/10/Z11
	private Date permanentAndTotalEffectiveDate = null;

	//ZSP/8/Z11
	private String awardDate = null;

	private RatedDisabilityCollection ratedDisabilities = null;

	private Date scReportDate;

	public String getAwardDate() {
		return awardDate;
	}

	public void setAwardDate(String awardDate) {
		this.awardDate = awardDate;
	}

	public String getCombinedServiceConnectedPercentageEffectiveDate() {
		return combinedServiceConnectedPercentageEffectiveDate;
	}

	public void setCombinedServiceConnectedPercentageEffectiveDate(
			String combinedServiceConnectedPercentageEffectiveDate) {
		this.combinedServiceConnectedPercentageEffectiveDate = combinedServiceConnectedPercentageEffectiveDate;
	}

	public Boolean getPermanentAndTotal() {
		return permanentAndTotal;
	}

	public void setPermanentAndTotal(Boolean permanentAndTotal) {
		this.permanentAndTotal = permanentAndTotal;
	}

	public Date getPermanentAndTotalEffectiveDate() {
		return permanentAndTotalEffectiveDate;
	}

	public void setPermanentAndTotalEffectiveDate(
			Date permanentAndTotalEffectiveDate) {
		this.permanentAndTotalEffectiveDate = permanentAndTotalEffectiveDate;
	}

	public RatedDisabilityCollection getRatedDisabilities() {
		return ratedDisabilities;
	}

	public void setRatedDisabilities(RatedDisabilityCollection ratedDisabilities) {
		this.ratedDisabilities = ratedDisabilities;
	}

	public Boolean getServiceConnectedIndicator() {
		return serviceConnectedIndicator;
	}

	public void setServiceConnectedIndicator(Boolean serviceConnectedIndicator) {
		this.serviceConnectedIndicator = serviceConnectedIndicator;
	}

	public Integer getServiceConnectedPercentage() {
		return serviceConnectedPercentage;
	}

	public void setServiceConnectedPercentage(Integer serviceConnectedPercentage) {
		this.serviceConnectedPercentage = serviceConnectedPercentage;
	}

	public Boolean getUnemployable() {
		return unemployable;
	}

	public void setUnemployable(Boolean unemployable) {
		this.unemployable = unemployable;
	}

	public Date getScReportDate() {
		return scReportDate;
	}

	public void setScReportDate(Date scReportDate) {
		this.scReportDate = scReportDate;
	}
}
