/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.external.person;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.ExternalServiceImpl;
import gov.va.med.esr.service.external.person.ejb.PersonServiceHome;
import gov.va.med.esr.service.external.person.ejb.RemotePersonService;

import java.rmi.RemoteException;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

/**
 * Business delegate, suitable for HeatheVet CAIP usage.
 *
 * Created Dec 23, 2005 11:57:43 AM
 *
 * @author DNS   BOHMEG
 */
public class PersonServiceImpl extends ExternalServiceImpl implements
		PersonService {
	/**
	 *
	 */
	private static final long serialVersionUID = 1267686755986748702L;

	/*
	 * (non-Javadoc)
	 *
	 * @see gov.va.med.esr.service.external.ExternalServiceImpl#getBusinessDelegateInterfaceInfo()
	 */
	public BusinessDelegateInfo getBusinessDelegateInterfaceInfo() {
		return new PersonServiceInfo();
	}


	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.external.ExternalServiceImpl#createEJB(javax.ejb.EJBHome)
	 */
	protected EJBObject createEJB(EJBHome home) throws RemoteException, CreateException {
		return ((PersonServiceHome) home).create();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.external.person.PersonService#link(gov.va.med.esr.service.external.person.VPIDEntityKey, gov.va.med.esr.service.external.person.VPIDEntityKey)
	 */
	public void link(VPIDEntityKey deprecatedVPID, VPIDEntityKey survivingVPID) throws ESRException {
		if (!deprecatedVPID.isDeprecated())
			throw new ESRException(
					"deprecatedVPID argument is not marked deprecated");
		if (survivingVPID.isDeprecated())
			throw new ESRException(
					"survivingVPID argument is marked deprecated");

		try {
			((RemotePersonService) getEJB()).link(deprecatedVPID, survivingVPID);
		} catch (Exception e) {
			throw new ESRException("Unable to handle link notification", e);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.external.person.PersonService#move(java.lang.String, java.lang.String, gov.va.med.esr.service.external.person.VPIDEntityKey, gov.va.med.esr.service.external.person.VPIDEntityKey)
	 */
	public void move(String dfn, String stationNumber, VPIDEntityKey fromVpid, VPIDEntityKey toVpid) throws ESRException {
			if (fromVpid.isDeprecated())
				throw new ESRException(
						"fromVpid VPID argument is marked deprecated");
			if (toVpid.isDeprecated())
				throw new ESRException(
						"toVpid VPID argument is marked deprecated");

			try {
				((RemotePersonService) getEJB()).move(dfn, stationNumber, fromVpid, toVpid);
			} catch (Exception e) {
				throw new ESRException("Unable to handle move  notification", e);
			}
	}


	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.external.person.PersonService#getEligibilitySummary(gov.va.med.esr.service.external.person.VPIDEntityKey)
	 */
	public EligibilitySummary getEligibilitySummary(VPIDEntityKey vpid) throws ESRException {
		if(vpid == null)
			throw new ESRException("VPID is null");

		try {
			return ((RemotePersonService) getEJB()).getEligibilitySummary(vpid);
		} catch (Exception e) {
			throw new ESRException("Unable to get summary of EE data", e);
		}
	}


	public SimpleEligibilitySummary getSimpleEligibilitySummary(String ssn) throws ESRException
	{
		try
		{
			return ((RemotePersonService) getEJB()).getSimpleEligibilitySummary(ssn);
		}catch (Exception e) {
			throw new ESRException("Unable to get SimpleEligibilitySummary", e);
		}
	}

	public EESummary getEESummary(EntityFinder arg) throws ESRException {
		if(arg == null)
			throw new ESRException("arg is null");

		try {
			return ((RemotePersonService) getEJB()).getEESummary(arg);
		} catch (Exception e) {
			throw new ESRException("Unable to get summary of EE data", e);
		}
	}

	

    public EESummary getEESummaryHistory(EntityFinder arg) throws ESRException {
        if(arg == null)
            throw new ESRException("arg is null");

        try {
            return ((RemotePersonService) getEJB()).getEESummaryHistory(arg);
        } catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

    public EESummary getEDStatus(EntityFinder arg) throws ESRException {
        if(arg == null)
            throw new ESRException("arg is null");

        try {
            return ((RemotePersonService) getEJB()).getEDStatus(arg);
        } catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

    public EESummary getPersonNotificationStatus(EntityFinder arg) throws ESRException {
        if(arg == null)
            throw new ESRException("arg is null");

        try {
            return ((RemotePersonService) getEJB()).getPersonNotificationStatus(arg);
        } catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

    public EESummary getDeliveryPreference(EntityFinder arg) throws ESRException {
        if(arg == null)
            throw new ESRException("arg is null");

        try {
            return ((RemotePersonService) getEJB()).getDeliveryPreference(arg);
        } catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

    public EESummary updateDeliveryPreference(EntityFinder arg) throws ESRException {
        if(arg == null)
            throw new ESRException("arg is null");

        try {
            return ((RemotePersonService) getEJB()).updateDeliveryPreference(arg);
        } catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

	public MSSummary getMSSummary(EntityFinder arg) throws ESRException {
		if(arg == null)
			throw new ESRException("arg is null");

		try {
			return ((RemotePersonService) getEJB()).getMSSummary(arg);
		} catch (Exception e) {
			throw new ESRException("Unable to get summary of EE data", e);
		}
	}

	public IVMSummary retrieveIVMCandidates(EntityFinder arg) throws ESRException {
		try {
			return ((RemotePersonService) getEJB()).retrieveIVMCandidates(arg);
		} catch (Exception e) {
			throw new ESRException("Unable to get summary of EE data", e);
		}

	}

	// ES 4.0_CodeCR12863_CR_EE Web Service Updates
	public IVMSummary retrieveIVMLetterCandidates() throws ESRException {
		try {
			return ((RemotePersonService) getEJB()).retrieveIVMLetterCandidates();
		} catch (Exception e) {
			throw new ESRException("Unable to get list IVM Letter Statuses", e);
		}
	}


	public IVMSummary updateIVMStatus(EntityFinder arg) throws ESRException {
		try {
			return ((RemotePersonService) getEJB()).updateIVMStatus(arg);
		} catch (Exception e) {
			throw new ESRException("Unable to get summary of EE data", e);
		}

	}

	public IVMSummary processIVMIncomeTest(EntityFinder arg) throws ESRException {
		try {
			return ((RemotePersonService) getEJB()).processIVMIncomeTest(arg);
		} catch (Exception e) {
			throw new ESRException("Unable to get summary of EE data", e);
		}

	}
}
