/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;

/**
 * Initial javadoc for class PersonService. TODO - Add content here
 *
 * Created Dec 23, 2005 10:36:23 AM
 *
 * @author DNS   BOHMEG
 */
public interface PersonService {
	/** HealtheVet terminology that equates to ESR "merge" */
	public void link(VPIDEntityKey deprecatedVPID,
			VPIDEntityKey survivingVPID) throws ESRException;

	/** HealtheVet terminology that equates to ESR "unmerge" */
	public void move(String dfn, String stationNumber, VPIDEntityKey fromVpid, VPIDEntityKey toVpid) throws ESRException;

	/** Api for HealtheVet systems to obtain EE data for an enumerated Person */
	public EligibilitySummary getEligibilitySummary(VPIDEntityKey vpid) throws ESRException;

	public SimpleEligibilitySummary getSimpleEligibilitySummary(String ssn) throws ESRException;

	public EESummary getEESummary(EntityFinder arg) throws ESRException;

	public MSSummary getMSSummary(EntityFinder arg) throws ESRException;

    public EESummary getEESummaryHistory(EntityFinder arg) throws ESRException;
   
    public EESummary getEDStatus(EntityFinder arg) throws ESRException;
    public EESummary getPersonNotificationStatus(EntityFinder arg)throws ESRException;
    public EESummary getDeliveryPreference(EntityFinder arg) throws ESRException;
    public EESummary updateDeliveryPreference(EntityFinder arg)throws ESRException;
    public IVMSummary retrieveIVMCandidates(EntityFinder arg) throws ESRException;
    public IVMSummary retrieveIVMLetterCandidates() throws ESRException;
    public IVMSummary updateIVMStatus(EntityFinder arg) throws ESRException;
    public IVMSummary processIVMIncomeTest(EntityFinder arg) throws ESRException;
}
