/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

/**
 * Initial javadoc for class PersonMoveInfo.
 * TODO - Add content here
 * 
 * Created Aug 25, 2006 1:58:52 PM
 * @author DNS   BOHMEG
 */
public class PersonMoveInfo extends ExternalComponent {
	private static final long serialVersionUID = -358545247064218017L;

    public static final String DEFAULT_MESSAGE_INITIATER = "PSIM move event";
    public static final String IVM_MESSAGE_INITIATER = "IVM move event";

	public final static String DEFAULT_MESSAGE_TYPE = "crossApplication.notification.personMove";

	private String dfn;
	private String stationNumber;
	private VPIDEntityKey fromVpid;

	private VPIDEntityKey toVpid;

	public PersonMoveInfo(String dfn, String stationNumber, VPIDEntityKey fromVpid,
			VPIDEntityKey toVpid) {
		this.dfn = dfn;
		this.stationNumber = stationNumber;
		this.fromVpid = fromVpid;
		this.toVpid = toVpid;
	}

	/**
	 * @return Returns the dfn.
	 */
	public String getDfn() {
		return dfn;
	}

	/**
	 * @param dfn The dfn to set.
	 */
	public void setDfn(String dfn) {
		this.dfn = dfn;
	}

	/**
	 * @return Returns the fromVpid.
	 */
	public VPIDEntityKey getFromVpid() {
		return fromVpid;
	}

	/**
	 * @param fromVpid The fromVpid to set.
	 */
	public void setFromVpid(VPIDEntityKey fromVpid) {
		this.fromVpid = fromVpid;
	}

	/**
	 * @return Returns the stationNumber.
	 */
	public String getStationNumber() {
		return stationNumber;
	}

	/**
	 * @param stationNumber The stationNumber to set.
	 */
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	/**
	 * @return Returns the toVpid.
	 */
	public VPIDEntityKey getToVpid() {
		return toVpid;
	}

	/**
	 * @param toVpid The toVpid to set.
	 */
	public void setToVpid(VPIDEntityKey toVpid) {
		this.toVpid = toVpid;
	}

}
